% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relsurv.haz_function.R
\name{haz_function}
\alias{haz_function}
\title{Helper function that calculates excess and population hazards for a given transition}
\usage{
haz_function(
  formula = formula(data),
  data,
  ratetable = relsurv::slopop,
  na.action,
  add.times,
  rmap,
  include.all.times = FALSE
)
}
\arguments{
\item{formula}{A non-parametric Surv-based formula, e.g. Surv(times, status)~1}

\item{data}{A subset of the msprep object (dataset) where there's 
only data for the chosen transition}

\item{ratetable}{A table of event rates, organized as a ratetable object, such as slopop}

\item{na.action}{A missing-data filter function, applied to the model.frame, after any subset argument has been used. Default is options()$na.action}

\item{add.times}{Additional times at which the hazards should be evaluated}

\item{rmap}{An optional list to be used if the variables are not organized and named in the same way as in the ratetable object}

\item{include.all.times}{Should hazards be evaluated at all times in seq(minimum time, maximum time, by=1). Default is FALSE}
}
\value{
A list containing the needed hazards.
}
\description{
A function that calculates the excess and population hazards
for a given transition. Code is based on function rs.surv from
the relsurv package.
}
\seealso{
\code{\link{msfit.relsurv}}
}
\author{
Damjan Manevski \email{damjan.manevski@mf.uni-lj.si}
}
