% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msentropy_similarity.R
\name{msentropy_similarity}
\alias{msentropy_similarity}
\title{Calculate spectral entropy similarity between two spectra}
\usage{
msentropy_similarity(
  peaks_a,
  peaks_b,
  ms2_tolerance_in_da = 0.02,
  ms2_tolerance_in_ppm = -1,
  clean_spectra = TRUE,
  min_mz = 0,
  max_mz = 1000,
  noise_threshold = 0.01,
  max_peak_num = 100,
  weighted = TRUE,
  ...
)
}
\arguments{
\item{peaks_a}{A two-column numeric matrix with the m/z and intensity values
for peaks of one spectrum.}

\item{peaks_b}{A two-column numeric matrix with the m/z and intensity values
for peaks of one spectrum.}

\item{ms2_tolerance_in_da}{The MS2 tolerance in Da, set to -1 to disable.
Defaults to \code{ms2_tolerance_in_da = 0.02}.}

\item{ms2_tolerance_in_ppm}{The MS2 tolerance in ppm, set to -1 to disable.
Defaults to \code{ms2_tolerance_in_ppm = -1}.}

\item{clean_spectra}{Whether to clean the spectra before calculating the
entropy similarity, see \code{\link[=clean_spectrum]{clean_spectrum()}}.}

\item{min_mz}{The minimum mz value to keep, set to -1 to disable. Defaults to
\code{min_mz = 0}.}

\item{max_mz}{The maximum mz value to keep, set to -1 to disable. Defaults to
\code{max_mz = 1000}.}

\item{noise_threshold}{The noise threshold, set to -1 to disable, all peaks
have intensity < noise_threshold * max_intensity will be removed.
Defaults to \code{noise_threshold = 0.01}, thus, by default, all peaks with
an intensity less than 1\% of the maximum intensity of a spectrum will
be removed.}

\item{max_peak_num}{The maximum number of peaks to keep, set to -1 to
disable. Defaults to \code{max_peak_num = 1000}.}

\item{weighted}{\code{logical(1)} whether the weighted or unweighted entropy
similarity should be calculated. Defaults to \code{weighted = TRUE}, thus
\code{\link[=calculate_entropy_similarity]{calculate_entropy_similarity()}} is used for the calculation. For
\code{weighted = FALSE} \code{\link[=calculate_unweighted_entropy_similarity]{calculate_unweighted_entropy_similarity()}} is used
instead.}

\item{...}{Optional additional parameters (currently ignored)}
}
\value{
The entropy similarity
}
\description{
\code{msentropy_similarity} calculates the spectral entropy between two spectra
(Li et al. 2021). It is a wrapper function defining defaults for parameters
and calling the \code{\link[=calculate_entropy_similarity]{calculate_entropy_similarity()}} or
\code{\link[=calculate_unweighted_entropy_similarity]{calculate_unweighted_entropy_similarity()}} functions to perform the
calculation.
}
\examples{

peaks_a <- cbind(mz = c(169.071, 186.066, 186.0769),
    intensity = c(7.917962, 1.021589, 100.0))
peaks_b <- cbind(mz = c(120.212, 169.071, 186.066),
    intensity <- c(37.16, 66.83, 999.0))
msentropy_similarity(peaks_a, peaks_b, ms2_tolerance_in_da = 0.02)
}
\references{
Li, Y., Kind, T., Folz, J. et al. (2021) Spectral entropy outperforms MS/MS
dot product similarity for small-molecule compound identification.
Nat Methods 18, 1524-1531.
\doi{10.1038/s41592-021-01331-z}.
}
