% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sim_com_results.R
\name{plot.sim_com_results}
\alias{plot.sim_com_results}
\title{Plot \code{sim_com_results} Object}
\usage{
\method{plot}{sim_com_results}(
  x,
  species = seq_len(dim(x$N_map)[4]),
  time_points = x$sim_time,
  type = "continuous",
  main,
  range,
  ...
)
}
\arguments{
\item{x}{An object of class \code{sim_com_results}, returned by \code{\link[=sim_com]{sim_com()}}.}

\item{species}{Integer vector. Species ID(s) to plot.}

\item{time_points}{Integer vector. Time step(s) to plot (excluding burn-in).}

\item{type}{Character vector of length 1. Type of map:
"continuous" (default), "classes" or "interval"  (case-sensitive)}

\item{main}{Character vector. Plot titles (one for each layer)}

\item{range}{Numeric vector of length 2. Range of values to be used for the
legend (if \code{type = "continuous"}), which by default is calculated from
the N_map slot of \code{sim_com_results} object}

\item{...}{Further arguments passed to \code{\link[terra:plot]{terra::plot}}}
}
\value{
#' * If \code{length(time_points) == 1}, returns a \code{SpatRaster} with species as layers.
\itemize{
\item If only one species is selected with multiple time points, returns a single \code{SpatRaster}.
}
}
\description{
Draws simulated abundance maps for any species at any time
}
\examples{
# Read simulation data from the mrangr package
simulated_com <- get_simulated_com()

# Plot
plot(simulated_com)

}
