% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_mu_synch.R
\name{visual_mu_synch}
\alias{visual_mu_synch}
\title{Determination of Motor Unit Synchronization by Visual Inspection of Cross
Correlation Histogram}
\usage{
visual_mu_synch(motor_unit_1, motor_unit_2, order = 1, binwidth =
 0.001, get_data = T, plot = F)
}
\arguments{
\item{motor_unit_1, motor_unit_2}{Numeric vectors of strictly increasing
numbers denoting sequential discharge times (in seconds) of a motor unit or
neuron or any strictly increasing point process.}

\item{order}{Numeric as a positive integer for the number of forward and
backward orders for calculating recurrence times. Default = 1.}

\item{binwidth}{Numeric as a positive for the bin allocation size for
computational histogram. Default = 0.001 sec or 1 ms.}

\item{get_data}{T/F logical for outputting motor unit data. Default is TRUE.}

\item{plot}{T/F logical for outputting the cross correlation histogram.
Default is FALSE.}
}
\value{
A list of lists containing motor unit data (the names of each
 discharge train used, number of discharges, the interspike intervals (ISI),
 mean ISI, and the recurrence times associated with each order) and
 synchronization indices.
 CIS = frequency of synchronized discharges.
 k' = ratio of total discharges in peak to expected discharges in peak.
 k'-1 = ratio of synchronized discharges to expected discharges in peak.
 S = ratio of synchronized discharges to total number of discharges of both
 motor units.
 E = ratio of synchronized discharges to non-synchronized discharges.
 SI = ratio of synchronized discharges to reference motor unit discharges.
}
\description{
Calculates the time-domain synchronization indices CIS, k', k'-1,
 S, E, SI (detailed below) between two  motor unit discharge trains based on
 a visual determination of peaks in the cumulative sum graph configured from
 the cross correlation histogram. Function calls dygraphs (allows zooming) to
 present the normalized cumulative sum. User is prompted to input the left
 and right boundaries (time points in seconds) of peak seen as a dramatic
 slope increase in the cumulative sum graph around 0. If no peak is detected,
 a default +/- 5 ms is used.

 Dygraphs package is leveraged in this function to plot the cumulative sum
 graph in Rstudio's viewer. This allows for interactions within the graph,
 specifically zoom and unzoom.
}
\examples{
  \donttest{
  x <- c(0.035, 0.115, 0.183, 0.250, 0.306, 0.377, 0.455, 0.512, 0.577,
  0.656, 0.739, 0.821, 0.866, 0.950, 1.014, 1.085, 1.153, 1.213, 1.279,
  1.355, 1.431, 1.482, 1.551, 1.631, 1.692, 1.749, 1.832, 1.897, 1.964,
  2.106, 2.149, 2.229, 2.302, 2.384, 2.420, 2.505, 2.592, 2.644, 2.722,
  2.801, 2.870, 2.926, 3.011, 3.098, 2.030, 3.183, 3.252, 3.319, 3.395,
  3.469, 3.560, 3.589, 3.666, 3.744, 3.828, 3.876, 3.943, 4.020, 4.104)
  x <- sort(x)
  y <- sort(jitter(x))
  y <- round(y, digits = 3)
  visual_mu_synch(x, y, order = 1, binwidth = 0.001, get_data = TRUE,
  plot = FALSE)
  }
}
\references{
Nordstrom, M.A., Fuglevand, A.J., Enoka, R.M. (1992) Estimating
 the Strength of Common Input to Human Motoneurons from the
 Cross-Correlogram. Journal of Physiology 453, pp. 547-574
}
\keyword{motor}
\keyword{recurrence,}
\keyword{synchronization,}
\keyword{unit,}
\keyword{visual}
