% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-SurvData.R
\name{PlotData}
\alias{PlotData}
\alias{plot.SurvDataVarExp}
\alias{plot.SurvDataCstExp}
\title{Plotting method for \code{survDataVar} objects}
\usage{
\method{plot}{SurvDataVarExp}(
  x,
  xlab = "Time",
  ylab = "Number of survivors",
  main = NULL,
  one_plot = FALSE,
  add_legend = FALSE,
  ...
)

\method{plot}{SurvDataCstExp}(
  x,
  xlab = "Time",
  ylab = "Number of survivors",
  main = NULL,
  one_plot = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{survData}.}

\item{xlab}{a label for the \eqn{X}-axis, by default \code{Time}.}

\item{ylab}{a label for the \eqn{Y}-axis, by default \code{Number of survivors}.}

\item{main}{main title for the plot.}

\item{one_plot}{if \code{TRUE}, draws all the points in one plot instead of
one per \code{replicate} or \code{conc}.}

\item{add_legend}{if \code{TRUE}, add the legend to the plot.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
an object of class \code{ggplot},
see function \code{\link[ggplot2]{ggplot}}
}
\description{
This is the generic \code{plot} S3 method for the \code{survDataVar} class.
It plots the number of survivors as a function of time.
}
\keyword{plot}
