% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maybe.R
\name{Maybe}
\alias{Maybe}
\title{The Maybe Monad}
\description{
The \href{https://armcn.github.io/maybe/}{maybe} package implements the Maybe
monad. It represents the explicit possiblity of absence of a value.
Methods for \code{\link[=fmap]{fmap()}}, \code{\link[=bind]{bind()}} and \code{\link[=join]{join()}} are provided for the \code{maybe}
S3 class as wrappers to functions in the package.
}
\examples{
\dontshow{if (requireNamespace("maybe", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# The fmap operator corresponds to maybe::maybe_map().
maybe::just(1) \%>>\% `+`(1)
maybe::nothing() \%>>\% `+`(1)

# The bind operator corresponds to maybe::and_then().
maybe::just(1) \%>-\% \(x) maybe::just(x + 1)
maybe::just(1) \%>-\% \(x) maybe::nothing()
maybe::nothing() \%>-\% \(x) maybe::just(1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[maybe:maybe_map]{maybe::maybe_map()}} which implements \code{\link[=fmap]{fmap()}} for \code{maybe}.

\code{\link[maybe:and_then]{maybe::and_then()}} which implements \code{\link[=bind]{bind()}} for \code{maybe}.

Other monads: 
\code{\link{List}}
}
\concept{monads}
