% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{intsPlot}
\alias{intsPlot}
\title{Plot confidence intervals for interaction terms}
\usage{
intsPlot(out, y = "all", nsims = 500, alpha = 0.05)
}
\arguments{
\item{out}{GGM moderated network output from \code{\link{fitNetwork}}, or
output from a moderated between-subjects network fit with
\code{\link{mlGVAR}} (e.g., when \code{bm = TRUE}).}

\item{y}{Character string. The name of the outcome variable for which to
create the plot. If \code{y = "all"}, then all interaction terms associated
with all outcomes will be plotted.}

\item{nsims}{The number of simulations to estimate the posterior distribution
of the difference between high and low levels of the confidence interval.}

\item{alpha}{Alpha level that is used to compute confidence intervals.}
}
\value{
A plot showing the spread of different interactions.
}
\description{
Allows one to plot the confidence intervals associated with interaction
terms. Provides an easy way to look at whether there are any significant
interactions, and if so which interactions are important.
}
\details{
The default setting \code{y = "all"} shows all interaction terms associated
with the model. But the user can also home-in on specific variables to see
what interactions might be relevant. When \code{y = "all"}, the axis labels
should be explained. These follow the format of \code{predictor:outcome}. The
title reflects the name of the moderator variable. For instance, if a
variable named \code{"M"} moderates the relationship between \code{"X"} and
\code{"Y"}, where \code{"X"} predicts \code{"Y"}, the title of the plot will
list the variable \code{"M"} as the moderator, and the label (shown on the
y-axis), will read \code{"X:Y"}. When \code{y != "all"} (that is, a specific
value for \code{y} is provided), then the title will still reflect the
moderator, but the labels will simply show which predictor interacts with
that moderator to predict the outcome.
}
\examples{
fit <- fitNetwork(ggmDat, 'M')
plot(fit, 'ints', y = 'all')
}
\seealso{
\code{\link{fitNetwork}, \link{plotNet}, \link{mlGVAR}}
}
