% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.MRSSkew}
\alias{test.MRSSkew}
\title{Test of multivariate normality based on the measure of multivariate skewness of Mori, Rohatgi and Szekely}
\usage{
test.MRSSkew(data, MC.rep = 10000, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value}

\item{alpha}{level of significance of the test}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.} }
}
\description{
Computes the multivariate normality test based on the invariant measure of multivariate sample skewness due to Mori, Rohatgi and Szekely (1993).
}
\details{
Multivariate sample skewness due to Mori, Rohatgi and Szekely (1993) is defined by
\deqn{\widetilde{b}_{n,d}^{(1)}=\frac{1}{n}\sum_{j=1}^n\|Y_{n,j}\|^2\|Y_{n,k}\|^2Y_{n,j}^\top Y_{n,k},}
where \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error. Note that for \eqn{d=1}, it is equivalent to skewness in the sense of Mardia.
}
\examples{
test.MRSSkew(MASS::mvrnorm(50,c(0,1),diag(1,2)),MC.rep=500)

}
\references{
Mori, T. F., Rohatgi, V. K., Szekely, G. J. (1993), On multivariate skewness and kurtosis, Theory of Probability and its Applications, 38:547-551.

Henze, N. (2002), Invariant tests for multivariate normality: a critical review, Statistical Papers, 43:467-506.
}
\seealso{
\code{\link{MRSSkew}}
}
