% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_select.R
\name{cpoSelect}
\alias{cpoSelect}
\alias{cpoSelectFreeProperties}
\title{Drop All Columns Except Certain Selected Ones from Data}
\usage{
cpoSelect(
  type = character(0),
  index = integer(0),
  names = character(0),
  pattern = NULL,
  pattern.ignore.case = FALSE,
  pattern.perl = FALSE,
  pattern.fixed = FALSE,
  invert = FALSE,
  id,
  export = "export.default",
  affect.type = NULL,
  affect.index = integer(0),
  affect.names = character(0),
  affect.pattern = NULL,
  affect.invert = FALSE,
  affect.pattern.ignore.case = FALSE,
  affect.pattern.perl = FALSE,
  affect.pattern.fixed = FALSE
)

cpoSelectFreeProperties(
  type = character(0),
  index = integer(0),
  names = character(0),
  pattern = NULL,
  pattern.ignore.case = FALSE,
  pattern.perl = FALSE,
  pattern.fixed = FALSE,
  invert = FALSE,
  id,
  export = "export.default",
  affect.type = NULL,
  affect.index = integer(0),
  affect.names = character(0),
  affect.pattern = NULL,
  affect.invert = FALSE,
  affect.pattern.ignore.case = FALSE,
  affect.pattern.perl = FALSE,
  affect.pattern.fixed = FALSE
)
}
\arguments{
\item{type}{[\code{character}]\cr
One or more out of \dQuote{numeric}, \dQuote{ordered}, \dQuote{factor}, \dQuote{other}.
The type of columns to keep. Default is \code{character(0)}.}

\item{index}{[\code{integer}]\cr
Indices of columns to keep. Note that the index counts columns without the target column(s).
This and the next parameter make it possible to re-order columns. While all columns which match either
\dQuote{type}, \dQuote{pattern} or \dQuote{index} remain in the resulting data, the ones
selected by \dQuote{index} are put at the front in the order specified.
Default is \code{integer(0)}.}

\item{names}{[\code{character}]\cr
Names of columns to keep. Matching columns will be kept in order of their names occurring, but after
the columns indicated in \dQuote{index}.}

\item{pattern}{[\code{character(1)}]\cr
A pattern to match against the column names. Same as in \code{\link{grep}}.
Default is \code{NULL} for no matching.}

\item{pattern.ignore.case}{[\code{logical(1)}]\cr
Influences behaviour of \dQuote{pattern}: Whether to perform case insensitive matching. Same as in \code{\link{grep}}.
Default is \code{FALSE}.}

\item{pattern.perl}{[\code{logical(1)}]\cr
Influences behaviour of \dQuote{pattern}: Should Perl-compatible regexps be used? Same as in \code{\link{grep}}.
Default is \code{FALSE}.}

\item{pattern.fixed}{[\code{logical(1)}]\cr
Influences behaviour of \dQuote{pattern}: Whether to use match \code{pattern} as as is. Same as in \code{\link{grep}}.
Default is \code{FALSE}.}

\item{invert}{[\code{logical(1)}]\cr
Invert column selection: Drop the named columns and return the rest, instead of keeping the selected
columns only. Default is \code{FALSE}.}

\item{id}{[\code{character(1)}]\cr
id to use as prefix for the CPO's hyperparameters. this
must be used to avoid name clashes when composing two
CPOs of the same type, or with learners or other CPOS
with hyperparameters with clashing names.}

\item{export}{[\code{character}]\cr
Either a character vector indicating the parameters to
export as hyperparameters, or one of the special values
\dQuote{export.all} (export all parameters),
\dQuote{export.default} (export all parameters that are exported by default),
\dQuote{export.set} (export all parameters that were set during construction),
\dQuote{export.default.set} (export the intersection of the \dQuote{default} and \dQuote{set} parameters),
\dQuote{export.unset} (export all parameters that were \emph{not} set during construction) or
\dQuote{export.default.unset} (export the intersection of the \dQuote{default} and \dQuote{unset} parameters).
Default is \dQuote{export.default}.}

\item{affect.type}{[\code{character} | \code{NULL}]\cr
Type of columns to affect. A subset of \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}, \dQuote{other}, or \code{NULL}
to not match by column type. Default is \code{NULL}.}

\item{affect.index}{[\code{numeric}]\cr
Indices of feature columns to affect. The order of indices given is respected. Target column indices are not counted
(since target columns are always included). Default is \code{integer(0)}.}

\item{affect.names}{[\code{character}]\cr
Feature names of feature columns to affect. The order of names given is respected. Default is \code{character(0)}.}

\item{affect.pattern}{[\code{character(1)} | \code{NULL}]\cr
\code{\link[base]{grep}} pattern to match feature names by. Default is \code{NULL} (no pattern matching)}

\item{affect.invert}{[\code{logical(1)}]\cr
Whether to affect all features \emph{not} matched by other \code{affect.*} parameters.}

\item{affect.pattern.ignore.case}{[\code{logical(1)}]\cr
Ignore case when matching features with \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}

\item{affect.pattern.perl}{[\code{logical(1)}]\cr
Use Perl-style regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}

\item{affect.pattern.fixed}{[\code{logical(1)}]\cr
Use fixed matching instead of regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Select columns by type or name. The parameters \dQuote{type} and
\dQuote{pattern} are additive; if both are given, all column that match
either will be returned.

\code{cpoSelectFreeProperties} behaves just as \code{cpoSelect}, with the additional function
that it is treated like a \code{\link{CPO}} that removes all data properties from the data.
This disables the internal property check and can be useful when trying to compose \code{\link{CPO}}s
that do not have compatible properties.
}
\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link[mlr]{Task}}s, \code{data.frame}s, \code{link[mlr]{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link[mlr]{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link[mlr]{getHyperPars}}
and \code{\link[ParamHelpers]{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: 
\code{\link{cpoApplyFun}()},
\code{\link{cpoApplyFunRegrTarget}()},
\code{\link{cpoAsNumeric}()},
\code{\link{cpoCache}()},
\code{\link{cpoCbind}()},
\code{\link{cpoCollapseFact}()},
\code{\link{cpoDropConstants}()},
\code{\link{cpoDropMostlyConstants}()},
\code{\link{cpoDummyEncode}()},
\code{\link{cpoFilterAnova}()},
\code{\link{cpoFilterCarscore}()},
\code{\link{cpoFilterChiSquared}()},
\code{\link{cpoFilterFeatures}()},
\code{\link{cpoFilterGainRatio}()},
\code{\link{cpoFilterInformationGain}()},
\code{\link{cpoFilterKruskal}()},
\code{\link{cpoFilterLinearCorrelation}()},
\code{\link{cpoFilterMrmr}()},
\code{\link{cpoFilterOneR}()},
\code{\link{cpoFilterPermutationImportance}()},
\code{\link{cpoFilterRankCorrelation}()},
\code{\link{cpoFilterRelief}()},
\code{\link{cpoFilterRfCImportance}()},
\code{\link{cpoFilterRfImportance}()},
\code{\link{cpoFilterRfSRCImportance}()},
\code{\link{cpoFilterSymmetricalUncertainty}()},
\code{\link{cpoFilterUnivariate}()},
\code{\link{cpoFilterVariance}()},
\code{\link{cpoFixFactors}()},
\code{\link{cpoIca}()},
\code{\link{cpoImpactEncodeClassif}()},
\code{\link{cpoImpactEncodeRegr}()},
\code{\link{cpoImpute}()},
\code{\link{cpoImputeConstant}()},
\code{\link{cpoImputeHist}()},
\code{\link{cpoImputeLearner}()},
\code{\link{cpoImputeMax}()},
\code{\link{cpoImputeMean}()},
\code{\link{cpoImputeMedian}()},
\code{\link{cpoImputeMin}()},
\code{\link{cpoImputeMode}()},
\code{\link{cpoImputeNormal}()},
\code{\link{cpoImputeUniform}()},
\code{\link{cpoLogTrafoRegr}()},
\code{\link{cpoMakeCols}()},
\code{\link{cpoMissingIndicators}()},
\code{\link{cpoModelMatrix}()},
\code{\link{cpoOversample}()},
\code{\link{cpoPca}()},
\code{\link{cpoProbEncode}()},
\code{\link{cpoQuantileBinNumerics}()},
\code{\link{cpoRegrResiduals}()},
\code{\link{cpoResponseFromSE}()},
\code{\link{cpoSample}()},
\code{\link{cpoScale}()},
\code{\link{cpoScaleMaxAbs}()},
\code{\link{cpoScaleRange}()},
\code{\link{cpoSmote}()},
\code{\link{cpoSpatialSign}()},
\code{\link{cpoTransformParams}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}
}
\concept{CPOs}
