% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskRegr_california_housing.R
\name{california_housing}
\alias{california_housing}
\alias{mlr_tasks_california_housing}
\title{Median House Value in California}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskRegr}.
}
\source{
https://www.kaggle.com/datasets/camnugent/california-housing-prices
}
\description{
A regression task to predict the median house value in California.

Contains 9 features and 20640 observations.
Target column is \code{"median_house_value"}.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("california_housing")
tsk("california_housing")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Dimensions: 20640x10
\item Properties: -
\item Has Missings: \code{TRUE}
\item Target: \dQuote{median_house_value}
\item Features: \dQuote{households}, \dQuote{housing_median_age}, \dQuote{latitude}, \dQuote{longitude}, \dQuote{median_income}, \dQuote{ocean_proximity}, \dQuote{population}, \dQuote{total_bedrooms}, \dQuote{total_rooms}
}
}

\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{Task}},
\code{\link{TaskClassif}},
\code{\link{TaskRegr}},
\code{\link{TaskSupervised}},
\code{\link{TaskUnsupervised}},
\code{\link{mlr_tasks}},
\code{\link{mlr_tasks_breast_cancer}},
\code{\link{mlr_tasks_german_credit}},
\code{\link{mlr_tasks_iris}},
\code{\link{mlr_tasks_mtcars}},
\code{\link{mlr_tasks_penguins}},
\code{\link{mlr_tasks_pima}},
\code{\link{mlr_tasks_sonar}},
\code{\link{mlr_tasks_spam}},
\code{\link{mlr_tasks_wine}},
\code{\link{mlr_tasks_zoo}}
}
\concept{Task}
