% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_lvq.R
\name{mlLvq}
\alias{mlLvq}
\alias{ml_lvq}
\alias{mlLvq.formula}
\alias{mlLvq.default}
\alias{summary.mlLvq}
\alias{print.summary.mlLvq}
\alias{predict.mlLvq}
\title{Supervised classification using learning vector quantization}
\usage{
mlLvq(train, ...)

ml_lvq(train, ...)

\method{mlLvq}{formula}(
  formula,
  data,
  k.nn = 5,
  size,
  prior,
  algorithm = "olvq1",
  ...,
  subset,
  na.action
)

\method{mlLvq}{default}(train, response, k.nn = 5, size, prior, algorithm = "olvq1", ...)

\method{summary}{mlLvq}(object, ...)

\method{print}{summary.mlLvq}(x, ...)

\method{predict}{mlLvq}(
  object,
  newdata,
  type = "class",
  method = c("direct", "cv"),
  na.action = na.exclude,
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to the classification method or its
\code{\link[=predict]{predict()}} method (not used here for now).}

\item{formula}{a formula with left term being the factor variable to predict
and the right term with the list of independent, predictive variables,
separated with a plus sign. If the data frame provided contains only the
dependent and independent variables, one can use the \code{class ~ .} short
version (that one is strongly encouraged). Variables with minus sign are
eliminated. Calculations on variables are possible according to usual formula
convention (possibly protected by using \code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{k.nn}{k used for k-NN number of neighbor considered. Default is 5.}

\item{size}{the size of the codebook. Defaults to
min(round(0.4 \* nc \* (nc - 1 + p/2),0), n) where nc is the number of
classes.}

\item{prior}{probabilities to represent classes in the codebook (default
values are the proportions in the training set).}

\item{algorithm}{\code{"olvq1"} (by default, the optimized 'lvq1' version), or
\code{"lvq1"}, \code{"lvq2"}, \code{"lvq3"}.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For [ml_lvq)] \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).

[ml_lvq)]: R:ml_lvq)}

\item{response}{a vector of factor of the classes.}

\item{x, object}{an \strong{mlLvq} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. For this method, only \code{"class"}
is accepted, and it is the default. It returns the predicted classes.}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases in
\verb{newdata=} if this argument is provided, or the cases in the training set
if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different dataset in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_lvq]{ml_lvq()}}/\code{\link[=mlLvq]{mlLvq()}} creates an \strong{mlLvq}, \strong{mlearning} object
containing the classifier and a lot of additional metadata used by the
functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the learning vector quantization
algorithms provided by \code{\link[class:olvq1]{class::olvq1()}}, \code{\link[class:lvq1]{class::lvq1()}}, \code{\link[class:lvq2]{class::lvq2()}},
and \code{\link[class:lvq3]{class::lvq3()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_lvq <- ml_lvq(data = iris_train, Species ~ .)
summary(iris_lvq)
predict(iris_lvq) # This object only returns classes
#' # Self-consistency, do not use for assessing classifier performances!
confusion(iris_lvq)
# Use an independent test set instead
confusion(predict(iris_lvq, newdata = iris_test), iris_test$Species)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also \code{\link[class:olvq1]{class::olvq1()}},
\code{\link[class:lvq1]{class::lvq1()}}, \code{\link[class:lvq2]{class::lvq2()}}, and \code{\link[class:lvq3]{class::lvq3()}} that actually do the
classification.
}
