% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_sim_anneal.R
\name{fct_sim_anneal}
\alias{fct_sim_anneal}
\title{Internal Simulated Annealing Function}
\usage{
fct_sim_anneal(
  x,
  y,
  k,
  init_assign,
  lambda,
  temp,
  mu,
  eps,
  accept_prob,
  sim_N,
  track,
  anneal_iter = 1000,
  verbose
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A matrix of responses.}

\item{k}{The number of groups.}

\item{init_assign}{An initial clustering assignment.}

\item{lambda}{A vector of penalization parameters.}

\item{temp}{The initial simulated annealing temperature, temp > 0.}

\item{mu}{The simulated annealing decrease temperature fraction. Once the best configuration cannot be improved, reduce the temperature to (mu)T, 0 < mu < 1.}

\item{eps}{The final simulated annealing temperature, eps > 0.}

\item{accept_prob}{The simulated annealing probability of accepting a new assignment 0 < accept_prob < 1. When closer to 1, trial assignments will only be small perturbation of the current assignment. When closer to 0, trial assignments are closer to random.}

\item{sim_N}{The simulated annealing number of iterations for reaching equilibrium.}

\item{track}{A likelihood tracking vector.}

\item{anneal_iter}{The maximum number of simulated annealing iterations.}

\item{verbose}{A boolean indicating whether to print to screen.}
}
\value{
An updated clustering vector.
}
\description{
Internal Simulated Annealing Function
}
\keyword{internal}
