% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_helper_functions.R
\name{calculate_r_estimates}
\alias{calculate_r_estimates}
\title{Calculate Reproduction Number Estimates}
\usage{
calculate_r_estimates(
  incidence,
  si_prob,
  dates,
  si_mean,
  si_sd,
  si_dist,
  smoothing
)
}
\arguments{
\item{incidence}{numeric vector; daily case counts. Must be non-negative integers.
Days with zero cases will have R estimates of NA}

\item{si_prob}{numeric matrix; serial interval probability matrix from
\code{\link{calculate_si_probability_matrix}}. Element \code{[i,j]}
represents the probability that case j infected case i}

\item{dates}{vector; dates corresponding to incidence data. Used for
right-truncation correction calculations}

\item{si_mean}{numeric; mean of the serial interval distribution in days}

\item{si_sd}{numeric; standard deviation of the serial interval distribution in days}

\item{si_dist}{character; distribution type for serial interval, either "gamma"
or "normal"}

\item{smoothing}{integer; window size for temporal smoothing (0 = no smoothing).
When > 1, applies centered moving average to reduce noise}
}
\value{
named list with two numeric vectors of the same length as \code{incidence}:
\itemize{
\item \code{r}: Raw case reproduction number estimates. Returns NA for days
with zero cases or single-case epidemics
\item \code{r_corrected}: Estimates with right-truncation correction applied.
Values > 10 are capped at NA to avoid unrealistic estimates
}
}
\description{
Implements the Wallinga-Lipsitch algorithm to estimate case reproduction
numbers from incidence data and serial interval probabilities. This function
performs the likelihood calculations for retrospective reproduction
number estimation.
}
\details{
The algorithm calculates the probability that each earlier case infected each
later case based on their time difference and the serial interval distribution.
These probabilities are then aggregated to estimate the expected number of
secondary cases generated by cases on each day.

The Wallinga-Lipsitch method works by:
\enumerate{
\item Computing transmission likelihoods from earlier to later cases
\item Normalizing these likelihoods to create proper probabilities
\item Aggregating probabilities to estimate expected secondary cases per primary case
\item Applying right-truncation correction for cases near the observation end
}

The right-truncation correction accounts for the fact that cases near the end
of the observation period may have generated secondary cases that occur after
data collection ended.
}
\seealso{
\code{\link{wallinga_lipsitch}} for the main user interface,
\code{\link{calculate_si_probability_matrix}} for probability matrix creation,
\code{\link{calculate_truncation_correction}} for correction details
}
