% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotgg}
\alias{plotgg}
\alias{plotgg.contdist}
\alias{plotgg.trans_contdist}
\alias{plotgg.discrdist}
\alias{plotgg.trans_discrdist}
\alias{plotgg.contmixdist}
\alias{plotgg.trans_contmixdist}
\alias{plotgg.discrmixdist}
\alias{plotgg.trans_discrmixdist}
\alias{plotgg.contdiscrmixdist}
\alias{plotgg.trans_contdiscrmixdist}
\alias{plotgg.compdist}
\alias{plotgg.trans_compdist}
\title{Autoplot of Distributions Using ggplot2}
\usage{
plotgg(x, which = "all", ...)

\method{plotgg}{contdist}(
  x,
  which = "all",
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1,
  size2 = 1,
  alpha1 = 0.7,
  alpha2 = 0.7,
  ...
)

\method{plotgg}{trans_contdist}(
  x,
  which = "all",
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1,
  size2 = 1,
  alpha1 = 0.7,
  alpha2 = 0.7,
  ...
)

\method{plotgg}{discrdist}(
  x,
  which = "all",
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PMF",
  size1 = 3.3,
  size2 = 3.3,
  alpha1 = 0.9,
  alpha2 = 0.9,
  col_segment = "#b05e0b",
  ...
)

\method{plotgg}{trans_discrdist}(
  x,
  which = "all",
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PMF",
  size1 = 3.3,
  size2 = 3.3,
  alpha1 = 0.9,
  alpha2 = 0.9,
  col_segment = "#b05e0b",
  ...
)

\method{plotgg}{contmixdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1,
  size2 = 1,
  alpha1 = 0.4,
  alpha2 = 0.4,
  legend.position1 = "none",
  legend.position2 = "none",
  ...
)

\method{plotgg}{trans_contmixdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1,
  size2 = 1,
  alpha1 = 0.4,
  alpha2 = 0.4,
  legend.position1 = "none",
  legend.position2 = "none",
  ...
)

\method{plotgg}{discrmixdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PMF",
  size1 = 1.6,
  size2 = 1.6,
  alpha1 = 0.4,
  alpha2 = 0.9,
  legend.position1 = "none",
  legend.position2 = "none",
  width = 0.25,
  ...
)

\method{plotgg}{trans_discrmixdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PMF",
  size1 = 1.6,
  size2 = 1.6,
  alpha1 = 0.4,
  alpha2 = 0.9,
  legend.position1 = "none",
  legend.position2 = "none",
  width = 0.25,
  ...
)

\method{plotgg}{contdiscrmixdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1.6,
  size2 = 1.6,
  alpha1 = 0.4,
  alpha2 = 0.4,
  legend.position1 = "none",
  legend.position2 = "none",
  ...
)

\method{plotgg}{trans_contdiscrmixdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1.6,
  size2 = 1.6,
  alpha1 = 0.4,
  alpha2 = 0.4,
  legend.position1 = "none",
  legend.position2 = "none",
  ...
)

\method{plotgg}{compdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1.6,
  size2 = 1.6,
  alpha1 = 0.4,
  alpha2 = 0.4,
  legend.position1 = "none",
  legend.position2 = "none",
  text_ylim = -0.01,
  col_segment = "white",
  lty_segment = 3,
  lwd_segment = 1.8,
  ...
)

\method{plotgg}{trans_compdist}(
  x,
  which = "all",
  only_mix = FALSE,
  pp1 = 1000,
  pp2 = 1000,
  col = "#F9D607",
  xlim1 = q(x, c(0.01, 0.99)),
  ylim1 = NULL,
  xlim2 = xlim1,
  ylim2 = NULL,
  xlab1 = NULL,
  ylab1 = NULL,
  xlab2 = NULL,
  ylab2 = NULL,
  main1 = "CDF",
  main2 = "PDF",
  size1 = 1.6,
  size2 = 1.6,
  alpha1 = 0.4,
  alpha2 = 0.4,
  legend.position1 = "none",
  legend.position2 = "none",
  text_ylim = -0.01,
  col_segment = "white",
  lty_segment = 3,
  lwd_segment = 1.8,
  ...
)
}
\arguments{
\item{x}{distribution object.}

\item{which}{whether to plot only CDF, PDF or both, default: 'all'.}

\item{...}{further arguments to be passed.}

\item{pp1}{number of points at which CDF is evaluated, default: 1000.}

\item{pp2}{number of points at which PDF is evaluated, default: 1000.}

\item{col}{color used in plot, default: '#122e94'.}

\item{xlim1}{xlim of CDF plot, default: q(x, c(0.01, 0.99)).}

\item{ylim1}{ylim of CDF plot, default: NULL.}

\item{xlim2}{xlim of PDF plot, default: xlim1.}

\item{ylim2}{ylim of PDF plot, default: NULL.}

\item{xlab1}{xlab of CDF plot, default: NULL.}

\item{ylab1}{ylab of CDF plot, default: NULL.}

\item{xlab2}{xlab of PDF plot, default: NULL.}

\item{ylab2}{ylab of PDF plot, default: NULL.}

\item{main1}{title of CDF plot, default: 'CDF'.}

\item{main2}{title of PDF plot, default: 'PDF'/'PMF'.}

\item{size1}{size used in CDF plot.}

\item{size2}{size used in PDF plot.}

\item{alpha1}{alpha used in CDF plot.}

\item{alpha2}{alpha used in PDF plot.}

\item{col_segment}{col of additional segment if contained in the plot (composite and discrete distributions).}

\item{only_mix}{whether to plot only mixture/composite model and not also the components, default: FALSE.}

\item{legend.position1}{legend.position used in CDF plot.}

\item{legend.position2}{legend.position used in PDF plot.}

\item{width}{width of the bars that are used to plot discrete mixtures, default: 0.25.}

\item{text_ylim}{y coordinate for text annotation, default: -0.01.}

\item{lty_segment}{lty of additional segment if contained in the plot (composite and discrete distributions).}

\item{lwd_segment}{lwd of additional segment if contained in the plot (composite and discrete distributions).}
}
\value{
ggplot object if which = "cdf" or which = "pdf". If both are plotted, the plots are
        merged using \code{multiplot()} function and a list with both plots is invisibly returned.
}
\description{
The function \code{plotgg} plots the CDF and PDF of a given distribution object.
}
\examples{
\dontrun{
N <- normdist()
autoplot(N)

# manipulating cdf plot
B <- binomdist(12, 0.5)
autoplot(-3*B, which = "cdf", xlim1 = c(-30, -10))
# manipulating pdf plot
autoplot(-3*B, which = "pdf", xlim2 = c(-30, -10))
}
}
