% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipplot_additivity_check_bar.R
\name{mipplot_additivity_check_bar}
\alias{mipplot_additivity_check_bar}
\title{Additivity check using bar plot}
\usage{
mipplot_additivity_check_bar(
  D,
  R,
  target_scenarios,
  target_rule_ids = 4,
  show_all_scenarios = FALSE,
  show_all_rule_ids = FALSE,
  debug = FALSE
)
}
\arguments{
\item{D}{A dataframe of IAMC data in tibble format to produce area plots.}

\item{R}{A dataframe of data aggregation rules (meta data).}

\item{target_scenarios}{A character vector of scenario names}

\item{target_rule_ids}{A list of rule id.}

\item{show_all_scenarios}{Set TRUE to show all scenarios.}

\item{show_all_rule_ids}{Set TRUE to show all rules.}

\item{debug}{Set TRUE if show intermediate dataframe using View function.}
}
\value{
A list of bar plots.
}
\description{
This function is used for debugging a rule table and data-set.
An input is a rule table and a data-set, the outputs are some bar plots
showing the divergence between the left-side variable and
the sum of the right-side variables.
}
\examples{
mipplot_additivity_check_bar(
   ar5_db_sample_data, ar5_db_sample_rule_table,
   target_scenarios = c("EMF27-450-Conv", "EMF27-Base-NucOff"))
}
