% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGP.R
\name{DGP}
\alias{DGP}
\title{DGP: data generation}
\usage{
DGP(n, m, beta)
}
\arguments{
\item{n}{an integer. The number of bags.}

\item{m}{an integer or vector of length \code{n}. If \code{m} is an integer, each bag has the identical number of instances, \code{m}. 
If \code{m} is a vector, the \code{i}th bag has \code{m[i]} instances.}

\item{beta}{a vector. The true regression coefficients.}
}
\value{
a list including (1) bag-level labels, \code{Z}, (2) the design matrix, \code{X}, and (3) bag ID of each instance, \code{ID}.
}
\description{
Generating the multiple-instance data set.
}
\examples{
data1 <- DGP(50, 3, runif(10, -5, 5))
data2 <- DGP(50, sample(3:5, 50, TRUE), runif(10, -5, 5))
}
