% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misvm_orova.R
\name{misvm_orova}
\alias{misvm_orova}
\alias{misvm_orova.default}
\alias{misvm_orova.formula}
\alias{misvm_orova.mi_df}
\title{Fit MI-SVM model to ordinal outcome data using One-vs-All}
\usage{
\method{misvm_orova}{default}(
  x,
  y,
  bags,
  cost = 1,
  method = c("heuristic", "mip", "qp-heuristic"),
  weights = TRUE,
  control = list(kernel = "linear", sigma = if (is.vector(x)) 1 else 1/ncol(x),
    nystrom_args = list(m = nrow(x), r = nrow(x), sampling = "random"), max_step = 500,
    type = "C-classification", scale = TRUE, verbose = FALSE, time_limit = 60, start =
    FALSE),
  ...
)

\method{misvm_orova}{formula}(formula, data, ...)

\method{misvm_orova}{mi_df}(x, ...)
}
\arguments{
\item{x}{A data.frame, matrix, or similar object of covariates, where each
row represents an instance. If a \code{mi_df} object is passed, \verb{y, bags} are
automatically extracted, and all other columns will be used as predictors.}

\item{y}{A numeric, character, or factor vector of bag labels for each
instance.  Must satisfy \code{length(y) == nrow(x)}. Suggest that one of the
levels is 1, '1', or TRUE, which becomes the positive class; otherwise, a
positive class is chosen and a message will be supplied.}

\item{bags}{A vector specifying which instance belongs to each bag.  Can be a
string, numeric, of factor.}

\item{cost}{The cost parameter in SVM. If \code{method = 'heuristic'}, this will
be fed to \code{kernlab::ksvm()}, otherwise it is similarly in internal
functions.}

\item{method}{The algorithm to use in fitting (default  \code{'heuristic'}).  When
\code{method = 'heuristic'}, which employs an algorithm similar to Andrews et
al. (2003). When \code{method = 'mip'}, the novel MIP method will be used.  When
\verb{method = 'qp-heuristic}, the heuristic algorithm is computed using the
dual SVM.  See details.}

\item{weights}{named vector, or \code{TRUE}, to control the weight of the cost
parameter for each possible y value.  Weights multiply against the cost
vector. If \code{TRUE}, weights are calculated based on inverse counts of
instances with given label, where we only count one positive instance per
bag. Otherwise, names must match the levels of \code{y}.}

\item{control}{list of additional parameters passed to the method that
control computation with the following components:
\itemize{
\item \code{kernel} either a character the describes the kernel ('linear' or
'radial') or a kernel matrix at the instance level.
\item \code{sigma} argument needed for radial basis kernel.
\item \code{nystrom_args} a list of parameters to pass to \code{\link[=kfm_nystrom]{kfm_nystrom()}}. This is
used when \code{method = 'mip'} and \code{kernel = 'radial'} to generate a Nystrom
approximation of the kernel features.
\item \code{max_step} argument used when \code{method = 'heuristic'}. Maximum steps of
iteration for the heuristic algorithm.
\item \code{type}: argument used when \code{method = 'heuristic'}. The \code{type} argument is
passed to \code{e1071::svm()}.
\item \code{scale} argument used for all methods. A logical for whether to rescale
the input before fitting.
\item \code{verbose} argument used when \code{method = 'mip'}. Whether to message output
to the console.
\item \code{time_limit} argument used when \code{method = 'mip'}. \code{FALSE}, or a time
limit (in seconds) passed to \code{gurobi()} parameters.  If \code{FALSE}, no time
limit is given.
\item \code{start} argument used when \code{method = 'mip'}.  If \code{TRUE}, the mip program
will be warm_started with the solution from \code{method = 'qp-heuristic'} to
potentially improve speed.
}}

\item{...}{Arguments passed to or from other methods.}

\item{formula}{a formula with specification \code{mi(y, bags) ~ x} which uses the
\code{mi} function to create the bag-instance structure. This argument is an
alternative to the \verb{x, y, bags} arguments, but requires the \code{data}
argument. See examples.}

\item{data}{If \code{formula} is provided, a data.frame or similar from which
formula elements will be extracted}
}
\value{
An object of class \code{misvm_orova}  The object contains at least the
following components:
\itemize{
\item \code{fits}: a list of \code{misvm} objects with length equal to the number of
classes in \code{y}. See \code{\link[=misvm]{misvm()}} for details on the \code{misvm} object.
\item \code{call_type}: A character indicating which method \code{misvm_orova()} was
called with.
\item \code{features}: The names of features used in training.
\item \code{levels}: The levels of \code{y} that are recorded for future prediction.
}
}
\description{
This function uses the one-vs-all multiclass classification strategy to fit a
series of MI-SVM models for predictions on ordinal outcome data.  For an
ordinal outcome with K levels, we fit K MI-SVM models to predict an
individual level vs not.
}
\section{Methods (by class)}{
\itemize{
\item \code{misvm_orova(default)}: Method for data.frame-like objects

\item \code{misvm_orova(formula)}: Method for passing formula

\item \code{misvm_orova(mi_df)}: Method for \code{mi_df} objects, automatically handling bag
names, labels, and all covariates.

}}
\examples{
data("ordmvnorm")
x <- ordmvnorm[, 3:7]
y <- ordmvnorm$bag_label
bags <- ordmvnorm$bag_name

mdl1 <- misvm_orova(x, y, bags)
predict(mdl1, x, new_bags = bags)

}
\references{
Andrews, S., Tsochantaridis, I., & Hofmann, T. (2002). Support
vector machines for multiple-instance learning. \emph{Advances in neural
information processing systems}, \emph{15}.
}
\seealso{
\code{\link[=predict.misvm_orova]{predict.misvm_orova()}} for prediction on new data.
}
\author{
Sean Kent
}
