% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_fm.R
\name{build_instance_feature}
\alias{build_instance_feature}
\title{Flatten \code{mild_df} data to the instance level}
\usage{
build_instance_feature(
  data,
  qtls = seq(0.05, 0.95, length.out = 10),
  mean = TRUE,
  sd = TRUE
)
}
\arguments{
\item{data}{A \code{mild_df} object.}

\item{qtls}{Quantiles to be extracted from each instance empirical
distribution.}

\item{mean}{A logical for whether or not to extract mean.}

\item{sd}{A logical for whether or not to extract standard deviation.}
}
\value{
A summarized data.frame at the instance level.
}
\description{
Flatten \code{mild_df} type of data to regular multiple instance data where
each instance is a vector by extracting distribution sample quantiles, mean
and sd.
}
\examples{
mild_df1 <- generate_mild_df(positive_degree = 3, nbag = 3)
df1 <- build_instance_feature(mild_df1, seq(0.05, 0.95, length.out = 10))

}
\seealso{
\code{\link[=summarize_samples]{summarize_samples()}} for a more general way to make a similar data
frame.
}
\author{
Yifei Liu
}
