% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{discr.sims.cross}
\alias{discr.sims.cross}
\title{Discriminability Cross Simulation}
\usage{
discr.sims.cross(
  n,
  d,
  K,
  signal.scale = 10,
  non.scale = 1,
  mean.scale = 0,
  rotate = FALSE,
  class.equal = TRUE,
  ind = FALSE
)
}
\arguments{
\item{n}{the number of samples.}

\item{d}{the number of dimensions.}

\item{K}{the number of classes in the dataset.}

\item{signal.scale}{the scaling for the signal dimension. Defaults to \code{10}.}

\item{non.scale}{the scaling for the non-signal dimensions. Defaults to \code{1}.}

\item{mean.scale}{whether the magnitude of the difference in the means between the two classes.
If a mean scale is requested, \code{d} should be at least > \code{K}.}

\item{rotate}{whether to apply a random rotation. Defaults to \code{TRUE}.}

\item{class.equal}{whether the number of samples/class should be equal, with each
class having a prior of 1/K, or inequal, in which each class obtains a prior
of k/sum(K) for k=1:K. Defaults to \code{TRUE}.}

\item{ind}{whether to sample x and y independently. Defaults to \code{FALSE}.}
}
\description{
A function to simulate data with the same mean that spreads as class id increases.
}
\examples{
library(mgc)
sim <- discr.sims.cross(100, 3, 2)
}
\author{
Eric Bridgeford
}
