% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mfp.R
\name{reset_acd}
\alias{reset_acd}
\title{Helper to reset acd transformation for variables with few values}
\usage{
reset_acd(x, acdx)
}
\arguments{
\item{x}{a design matrix of dimension nobs x nvars where nvars is the number
of predictors excluding an intercept.}

\item{acdx}{a named logical vector of length nvars indicating which continuous
variables should undergo the approximate cumulative distribution (ACD)
transformation. May be ordered differently than the columns of \code{x}.}
}
\value{
Logical vector of same length as \code{acdx}.
}
\description{
To be used in \code{\link[=fit_mfp]{fit_mfp()}}.
This function resets the \code{acdx} parameter (logical vector) of variables with
less than 5 distinct values to \code{FALSE}.
}
