% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\name{pp.weibull}
\alias{pp.weibull}
\title{Weibull plotting position}
\usage{
pp.weibull(x)
}
\arguments{
\item{x}{Numeric vector of block maxima}
}
\value{
A numeric vector of Weibull plotting positions corresponding to the given maxima \code{x}
}
\description{
Calculates the Weibull plotting position for the given maxima
}
\examples{
data(dailyrainfall)
fit <- fsmev(dailyrainfall)
rp <- pp.weibull(fit$maxima)
rl <- return.levels.mev(fit, return.periods = rp)
plot(rp, sort(fit$maxima), xlab = "Return period (years)", ylab = "Return level", main = fit$type)
lines(rp, rl$rl)
}
