% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{egp}
\alias{egp}
\title{Extended generalised Pareto families}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{par}{parameter vector (\eqn{\kappa}, \eqn{\sigma}, \eqn{\xi}).}

\item{model}{a string indicating which extended family to fit}

\item{show}{logical; if \code{TRUE}, print the results of the optimization}

\item{p}{extreme event probability; \code{p} must be greater than the rate of exceedance for the calculation to make sense. See \bold{Details}.}

\item{plot}{logical; if \code{TRUE}, a plot of the return levels}
}
\value{
\code{egp.ll} returns the log-likelihood value, while \code{egp.retlev} returns a plot of the return levels if \code{plot=TRUE} and a list with tail probabilities \code{p}, return levels \code{retlev}, thresholds \code{thresh} and model name \code{model}.
}
\description{
This function provides the log-likelihood and quantiles for the three different families presented
in Papastathopoulos and Tawn (2013) and the two proposals of Gamet and Jalbert (2022), plus exponential tilting. All of the models contain an additional parameter, \eqn{\kappa \ge 0}.
All families share the same tail index as the generalized Pareto distribution, while allowing for lower thresholds.
For most models, the distribution reduce to the generalised Pareto when \eqn{\kappa=1} (for models \code{gj-tnorm} and \code{logist}, on the boundary of the parameter space when \eqn{\kappa \to 0}).

\code{egp.retlev} gives the return levels for the extended generalised Pareto distributions
}
\details{
For return levels, the \code{p} argument can be related to \eqn{T} year exceedances as follows:
if there are \eqn{n_y} observations per year, than take \code{p}
to equal \eqn{1/(Tn_y)} to obtain the \eqn{T}-years return level.
}
\section{Usage}{

\code{egp.ll(xdat, thresh, model, par)}


\code{egp.retlev(xdat, thresh, par, model, p, plot=TRUE)}
}

\examples{
set.seed(123)
xdat <- rgp(1000, loc = 0, scale = 2, shape = 0.5)
par <- fit.egp(xdat, thresh = 0, model = 'gj-beta')$par
p <- c(1/1000, 1/1500, 1/2000)
# With multiple thresholds
th <- c(0, 0.1, 0.2, 1)
opt <- tstab.egp(xdat, thresh = th, model = 'gj-beta')
egp.retlev(xdat = xdat, thresh = th, model = 'gj-beta', p = p)
opt <- tstab.egp(xdat, th, model = 'pt-power', plots = NA)
egp.retlev(xdat = xdat, thresh = th, model = 'pt-power', p = p)
}
\references{
Papastathopoulos, I. and J. Tawn (2013). Extended generalised Pareto models for tail estimation, \emph{Journal of Statistical Planning and Inference} \bold{143}(3), 131--143, <doi:10.1016/j.jspi.2012.07.001>.

Gamet, P. and Jalbert, J. (2022). A flexible extended generalized Pareto distribution for tail estimation. \emph{Environmetrics}, \bold{33}(6), <doi:10.1002/env.2744>.
}
\author{
Leo Belzile
}
