% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_main.R
\name{varevalue.metilene}
\alias{varevalue.metilene}
\title{Calculate E-value of the Metilene data}
\usage{
varevalue.metilene(
  a,
  b,
  a_b,
  group1_name = "g1",
  group2_name = "g2",
  adjust.methods = "BH"
)
}
\arguments{
\item{a}{A data.frame object:
\tabular{rrrrrrrr}{
 chr    \tab  pos     \tab   g1    \tab ...  \tab  g1 \tab  g2 \tab ... \tab g2 \cr
chr1 \tab  1    \tab  0.1 \tab  ... \tab   0.1\tab  0.2\tab ... \tab 0.2\cr
}
i.e two key columns (chrom, pos) with several value columns in groups.}

\item{b}{A data.frame object stores the data, the columns are (in order):

    - chr:   Chromosome

    - start: The positions of the start sites of the corresponding region

    - end: The positions of the end sites of the corresponding region

    - q-value: The adjusted p-value based on BH method in MWU-test

    - methyl.diff: The difference between the group means of methylation level

    - CpGs:  The number of CpG sites within the corresponding region

    - p : p-value based on MWU-test

    - p2: p-value based on 2D KS-test

    - m1:  The absolute mean methylation level for the corresponding segment of group 1

    - m2:  The absolute mean methylation level for the corresponding segment of group 2}

\item{a_b}{A data.frame object of a join b with particular data clean processes. Check the function [evalue.methylKit.chk()] for more details.}

\item{group1_name}{charactor: The name of the first group. For example, "g1" in the above example.}

\item{group2_name}{charactor: The name of the second group. For example, "g2" in the above example.}

\item{adjust.methods}{is the adjust methods of e-value. It can be 'bonferroni', 'hochberg', 'holm', 'hommel', 'BH', 'BY'. The default value is 'BH'.}
}
\value{
a dataframe, the columns are (in order):

    - chr:   Chromosome

    - start: The positions of the start sites of the corresponding region

    - end: The positions of the end sites of the corresponding region

    - q-value: The adjusted p-value based on BH method in MWU-test

    - methyl.diff: The difference between the group means of methylation level

    - CpGs:  The number of CpG sites within the corresponding region

    - p : p-value based on MWU-test

    - p2: p-value based on 2D KS-test

    - m1:  The absolute mean methylation level for the corresponding segment of group 1

    - m2:  The absolute mean methylation level for the corresponding segment of group 2

    - e_value: The e-value of the corresponding region
}
\description{
The data file could be pre-handled by the evalue.metilene.chk function.
}
\examples{
#data(demo_metilene_input)
#data(demo_metilene_out)
#result = evalue_buildin_var_fmt_nm(demo_metilene_input, demo_metilene_out, method="metilene")
#result = list(a = result$a, 
#              b = result$b, 
#              a_b = evalue_buildin_sql(result$a, result$b, method="metilene"))
#result = varevalue.metilene(result$a, result$b, result$a_b)
}
