% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_summary_interpolated_data.R
\name{summarise_interpolator}
\alias{summarise_interpolator}
\title{Summarise interpolator objects by temporal dimension}
\usage{
summarise_interpolator(
  interpolator,
  fun = "mean",
  frequency = NULL,
  vars_to_summary = c("Temperature", "MinTemperature", "MaxTemperature", "Precipitation",
    "RelativeHumidity", "MinRelativeHumidity", "MaxRelativeHumidity", "Radiation",
    "WindSpeed", "WindDirection", "PET", "SmoothedPrecipitation",
    "SmoothedTemperatureRange", "elevation", "slope", "aspect"),
  dates_to_summary = NULL,
  months_to_summary = 1:12,
  verbose = getOption("meteoland_verbosity", TRUE),
  ...
)
}
\arguments{
\item{interpolator}{An interpolator object as created by \code{\link{create_meteo_interpolator}}.}

\item{fun}{The function to use for summarising the data.}

\item{frequency}{A string indicating the interval specification (allowed ones
are "week", "month", "quarter" and "year"). If NULL (default), aggregation
is done in one interval for all the dates present.}

\item{vars_to_summary}{A character vector with one or more variable names to
summarise. By default, all interpolated variables are summarised.}

\item{dates_to_summary}{A Date object to define the dates to be summarised.
If NULL (default), all dates in the interpolated data are processed.}

\item{months_to_summary}{A numeric vector with the month numbers to subset
the data before summarising. (e.g. \code{c(7,8)} for July and August).
This parameter allows studying particular seasons, when combined with
\code{frequency}. For example \code{frequency = "years"} and
\code{months = 6:8} leads to summarizing summer months of each year.}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}

\item{...}{Arguments needed for \code{fun}}
}
\value{
\code{summarise_interpolator} function returns the same interpolator object provided with the
temporal dimension aggregated to desired frequency.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Summarises an interpolator object by the desired temporal scale.
}
\examples{
\donttest{
# example interpolator
meteoland_interpolator_example

# aggregate all dates in the interpolator, calculating the maximum values
summarise_interpolator(meteoland_interpolator_example, fun = "max")

# aggregate weekly, calculating mean values
summarise_interpolator(meteoland_interpolator_example, frequency = "week")

}

}
\author{
\enc{Víctor}{Victor} Granda \enc{García}{Garcia}, CREAF
}
