% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_evt.R
\name{calc_pv}
\alias{calc_pv}
\title{Potential Vorticity (PV)}
\usage{
calc_pv(
  t_fld,
  u_fld,
  v_fld,
  w_fld,
  lev_p,
  lat = NULL,
  dx = 0.25,
  dy = 0.25,
  zvort_only = FALSE,
  relative = FALSE,
  zvort_fld = NULL,
  mode = "lonlat"
)
}
\arguments{
\item{t_fld}{temperature field [K]}

\item{u_fld}{zonal velocity field [m/s]}

\item{v_fld}{meridional velocity field [m/s]}

\item{w_fld}{vertical velocity field [m/s]}

\item{lev_p}{vector containing pressure levels [Pa]}

\item{lat}{vector containing latitude}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{zvort_only}{logical, TRUE: if only the vertical vorticity (zvort) should be calculated, FALSE: for the whole vorticity vector, default: FALSE}

\item{relative}{logical, TRUE: only relative vorticity, FALSE: whole (absolute) vorticity, default: FALSE}

\item{zvort_fld}{optional zvort field (if e.g., zvort is directly taken from ERA5 and not calculated separately)}

\item{mode}{use 'lonlat' if the data is given on a lon-lat-grid or 'cartesian' if the data is given on an equidistant cartesian grid}
}
\value{
potential vorticity field [K*m^2/(kg*s)]
}
\description{
Calculates the potential vorticity
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
#PV based on all three components
pv=calc_pv(data$temp,data$u,data$v,data$w,data$lev,lat=data$lat)
#PV only based on vertical component
pv_vert=calc_pv(data$temp,data$u,data$v,data$w,lev_p=data$lev,lat=data$lat,zvort_only=TRUE)
}
