% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{summary.minima3d}
\alias{summary.minima3d}
\title{Print minima3d object summary}
\usage{
\method{summary}{minima3d}(object, temp = 300, eunit = "kJ/mol", ...)
}
\arguments{
\item{object}{minima3d object}

\item{temp}{temperature in Kelvins}

\item{eunit}{energy units (kJ/mol or kcal/mol, kJ/mol is default)}

\item{...}{further arguments passed to or from other methods.}
}
\description{
`summary.minima3d` prints summary for 3D free energy minima (identifier, values of bins and collective variables,
free energy and equilibrium populations).
}
\examples{
tfes<-fes(acealanme3d, imax=5000)
minima<-fesminima(tfes)
summary(minima)
}
