% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLUE.R
\name{Luo.mean}
\alias{Luo.mean}
\title{Luo et al.'s mean estimators}
\usage{
Luo.mean(X, n, type)
}
\arguments{
\item{X}{a vector of ordered summary statistics}

\item{n}{the sample size}

\item{type}{a character string indicating which type of summary statistics is reported. The options for the \strong{type} argument are: 
\itemize{
   \item "S1" for the sample mean, minimum and maximum values
   \item "S2" for the sample mean, first and third quartiles
   \item "S3" for the sample mean, first and third quartiles, and minimum and maximum values
}}
}
\description{
Use Luo et al.'s methods (Luo et al., 2016) to estimate the sample mean based on sample quantiles derived summaries for a single study.
}
\examples{
X<-c(1,4,10)
n<-30
type<-"S1"
Luo.mean(X,n,type)
}
\references{
Luo D, Wan X, Liu J, and Tong T. (2016). Optimally estimating the sample mean from the sample size, median, mid-range, and/or mid-quartile range. \emph{Statistical Methods in Medical Research}, arXiv:1505.05687.
}
