% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_story.R
\name{get_story}
\alias{get_story}
\title{Get story by id}
\usage{
get_story(story_id, api_key = Sys.getenv("MEDIACLOUD_API_KEY"))
}
\arguments{
\item{story_id}{Positive numeric that contains a valid story id.}

\item{api_key}{Character string with the API key you get from mediacloud.org.
Passing it is compulsory. Alternatively, function can be
provided from the global environment.}
}
\value{
Data frame with results. See \url{https://github.com/berkmancenter/mediacloud/blob/master/doc/api_2_0_spec/api_2_0_spec.md#stories} for field descriptions.
}
\description{
\code{get_story} returns news stories by their id. One story represents
one online publication. Each story refers to a single URL from any feed
within a single media source.
}
\examples{
\dontrun{
 story <- get_story(story_id = 604L)
}

}
