% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bloodpressure}
\alias{bloodpressure}
\title{PDAC blood pressure data [replicates study]}
\format{
A data frame with 450 rows and 6 variables:
\describe{
  \item{creatinine}{Serum creatinine (umol/L)}
  \item{age}{Age (years)}
  \item{sbp30}{Systolic blood pressure at 30 minutes (mm Hg)}
  \item{sbp60}{Systolic blood pressure at 60 minutes (mm Hg)}
  \item{sbp90}{Systolic blood pressure at 90 minutes (mm Hg)}
  \item{sbp120}{Systolic blood pressure at 120 minutes (mm Hg)}
}
}
\usage{
bloodpressure
}
\description{
Blood pressure, age and creatinine levels of 450 pregnant women from the
Pregnancy Day Assessment Clinic.
}
\details{
This is a simulated dataset inspired by data that was originally published at the Dryad Digital Repository: <doi:10.5061/dryad.0bq15>
}
\examples{
data("bloodpressure", package = "mecor")
}
\references{
Elizabeth Anne McCarthy, Thomas A Carins, Yolanda Hannigan, Nadia Bardien, Alexis Shub, and Susan P Walker. Data from: Effectiveness and safety of 1 vs 4h blood pressure profile with clinical and laboratory assessment for the exclusion of gestational hypertension and pre-eclampsia: a retrospective study in a university affiliated maternity hospital. Dryad (2015). <doi:10.5061/dryad.0bq15>.
}
\keyword{datasets}
