% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep-fit-dcm.R
\name{measr_dcm}
\alias{measr_dcm}
\title{Fit Bayesian diagnostic classification models}
\usage{
measr_dcm(
  data,
  missing = NA,
  qmatrix,
  resp_id = NULL,
  item_id = NULL,
  type = c("lcdm", "dina", "dino", "crum"),
  max_interaction = Inf,
  attribute_structure = c("unconstrained", "independent"),
  method = c("variational", "mcmc", "optim"),
  prior = NULL,
  backend = getOption("measr.backend", "rstan"),
  file = NULL,
  file_refit = getOption("measr.file_refit", "never"),
  ...
)
}
\arguments{
\item{data}{Response data. A data frame with 1 row per respondent and 1
column per item.}

\item{missing}{An \code{R} expression specifying how missing data in \code{data} is
coded (e.g., \code{NA}, \code{"."}, \code{-99}, etc.). The default is \code{NA}.}

\item{qmatrix}{The Q-matrix. A data frame with 1 row per item and 1 column
per attribute. All cells should be either 0 (item does not measure the
attribute) or 1 (item does measure the attribute).}

\item{resp_id}{Optional. Variable name of a column in \code{data} that
contains respondent identifiers. \code{NULL} (the default) indicates that no
identifiers are present in the data, and row numbers will be used as
identifiers.}

\item{item_id}{Optional. Variable name of a column in \code{qmatrix} that contains
item identifiers. \code{NULL} (the default) indicates that no identifiers are
present in the Q-matrix. In this case, the column names of \code{data}
(excluding any column specified in \code{resp_id}) will be used as the item
identifiers. \code{NULL} also assumes that the order of the rows in the Q-matrix
is the same as the order of the columns in \code{data} (i.e., the item in row 1
of \code{qmatrix} is the item in column 1 of \code{data}, excluding \code{resp_id}).}

\item{type}{Type of \acronym{DCM} to estimate. Must be one of
\code{"lcdm"}, \code{"dina"}, \code{"dino"}, or \code{"crum"}.}

\item{max_interaction}{If \code{type = "lcdm"}, the highest level of interaction
to estimate. The default is to estimate all possible interactions. For
example, an item that measures 4 attributes would have 4 main effects,
6 two-way interactions, 4 three-way interactions, and 1 four-way
interaction. Setting \code{max_interaction = 2} would result in only estimating
the main effects and two-way interactions, excluding the three- and four-
way interactions.}

\item{attribute_structure}{Structural model specification. Must be one of
\code{"unconstrained"} or \code{"independent"}.
\code{"unconstrained"} makes no assumptions about the relationships between
attributes, whereas \code{"independent"} assumes that proficiency statuses on
attributes are independent of each other.}

\item{method}{Estimation method. Options are \code{"variational"}, which uses
Stan's variational algorithm; \code{"mcmc"}, which uses Stan's sampling method;
or \code{"optim"}, which uses Stan's optimizer.}

\item{prior}{A \link[dcmstan:prior]{prior} object. If \code{NULL}, default priors
are used, as specified by \code{\link[dcmstan:default_dcm_priors]{dcmstan::default_dcm_priors()}}.}

\item{backend}{Character string naming the package to use as the backend for
fitting the Stan model. Options are \code{"rstan"} (the default) or
\code{"cmdstanr"}. Can be set globally for the current \code{R} session via the
"measr.backend" option (see \code{\link[=options]{options()}}). Details on the rstan and
cmdstanr packages are available at \url{https://mc-stan.org/rstan/} and
\url{https://mc-stan.org/cmdstanr/}, respectively.}

\item{file}{Either \code{NULL} (the default) or a character string. If a character
string, the fitted model object is saved as an \code{.rds} object using
\code{\link[=saveRDS]{saveRDS()}} using the supplied character string. The \code{.rds} extension
is automatically added. If the specified file already exists, measr
will load the previously saved model. Unless \code{file_refit} is specified, the
model will not be refit.}

\item{file_refit}{Controls when a saved model is refit. Options are
\code{"never"}, \code{"always"}, and \code{"on_change"}. Can be set globally for the
current \code{R} session via the "measr.file_refit" option (see \code{\link[=options]{options()}}).
\itemize{
\item For \code{"never"} (the default), the fitted model is always loaded if the
\code{file} exists, and model fitting is skipped.
\item For \code{"always"}, the model is always refitted, regardless of whether or
not \code{file} exists.
\item For \code{"on_change"}, the model will be refit if the \code{data}, \code{prior}, or
\code{method} specified are different from that in the saved \code{file}.
}}

\item{...}{Additional arguments passed to Stan.
\itemize{
\item For \code{backend = "rstan"}, arguments are passed to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}
or \code{\link[rstan:stanmodel-method-optimizing]{rstan::optimizing()}}.
\item For \code{backend = "cmdstanr"}, arguments are passed to the
\href{https://mc-stan.org/cmdstanr/reference/model-method-sample.html}{sample}
or
\href{https://mc-stan.org/cmdstanr/reference/model-method-optimize.html}{optimize}
methods of the
\href{https://mc-stan.org/cmdstanr/reference/CmdStanModel.html}{CmdStanModel}
class.
}}
}
\value{
A \code{measrdcm} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{measr_dcm()} has been deprecated in favor of \code{\link[=dcm_estimate]{dcm_estimate()}}. Please use
\code{\link[=dcm_estimate]{dcm_estimate()}}, as \code{measr_dcm()} will be removed in a future release.
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
rstn_mdm_lcdm <- measr_dcm(
  data = mdm_data,
  missing = NA,
  qmatrix = mdm_qmatrix,
  resp_id = "respondent",
  item_id = "item",
  type = "lcdm",
  method = "optim",
  seed = 63277,
  backend = "rstan"
)
\dontshow{\}) # examplesIf}
}
\concept{Bayesian}
\concept{Stan}
\keyword{internal}
