% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_methods.R, R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot,BAsummary-method}
\alias{autoplot,MCResult-method}
\title{Generate a \code{ggplot} for Bland-Altman Plot and Regression Plot}
\usage{
autoplot(object, ...)

\S4method{autoplot}{BAsummary}(
  object,
  type = c("absolute", "relative"),
  color = "black",
  fill = "lightgray",
  size = 1.5,
  shape = 21,
  jitter = FALSE,
  ref.line = TRUE,
  ref.line.params = list(col = "blue", linetype = "solid", size = 1),
  ci.line = FALSE,
  ci.line.params = list(col = "blue", linetype = "dashed"),
  loa.line = TRUE,
  loa.line.params = list(col = "blue", linetype = "dashed"),
  label = TRUE,
  label.digits = 4,
  label.params = list(col = "black", size = 4),
  x.nbreak = NULL,
  y.nbreak = NULL,
  x.title = NULL,
  y.title = NULL,
  main.title = NULL
)

\S4method{autoplot}{MCResult}(
  object,
  color = "black",
  fill = "lightgray",
  size = 1.5,
  shape = 21,
  jitter = FALSE,
  identity = TRUE,
  identity.params = list(col = "gray", linetype = "dashed"),
  reg = TRUE,
  reg.params = list(col = "blue", linetype = "solid"),
  equal.axis = FALSE,
  legend.title = TRUE,
  legend.digits = 2,
  x.nbreak = NULL,
  y.nbreak = NULL,
  x.title = NULL,
  y.title = NULL,
  main.title = NULL
)
}
\arguments{
\item{object}{(\code{BAsummary}, \code{MCResult})\cr input, depending on which function
you have done, \code{blandAltman()} or \code{mcreg()}.}

\item{...}{not used.}

\item{type}{(\code{string})\cr difference type from input, default is 'absolute'.}

\item{color, fill}{(\code{string})\cr point colors.}

\item{size}{(\code{numeric})\cr the size of points.}

\item{shape}{(\code{integer})\cr the \code{ggplot} shape of points.}

\item{jitter}{(\code{logical})\cr whether to add a small amount of random variation
to the location of points.}

\item{ref.line}{(\code{logical})\cr whether to plot a 'mean' line, default is TRUE.}

\item{ref.line.params, ci.line.params, loa.line.params}{(\code{list})\cr parameters
(color, linetype, linewidth) for the argument 'ref.line', 'ci.line' and 'loa.line';
eg. ref.line.params = list(col = "blue", linetype = "solid", linewidth = 1).}

\item{ci.line}{(\code{logical})\cr whether to plot a confidence interval line of 'mean',
default is FALSE.}

\item{loa.line}{(\code{logical})\cr whether to plot limit of agreement line, default is TRUE.}

\item{label}{(\code{logical})\cr whether to add specific value label for each line
(ref.line, ci.line and loa.line). Only be shown when the line is defined as TRUE.}

\item{label.digits}{(\code{integer})\cr the number of digits after the decimal point
in the each label.}

\item{label.params}{(\code{list})\cr parameters (color, size, fontface) for the
argument 'label'.}

\item{x.nbreak, y.nbreak}{(\code{integer})\cr an integer guiding the number of major
breaks of x-axis and y-axis.}

\item{x.title, y.title, main.title}{(\code{string})\cr the x-axis, y-axis and main
title of plot.}

\item{identity}{(\code{logical})\cr whether to add identity line, default is TRUE.}

\item{identity.params, reg.params}{(\code{list})\cr parameters (color, linetype)
for the argument 'identity' and 'reg'; eg. identity.params = list(col = "gray",
linetype = "dashed").}

\item{reg}{(\code{logical})\cr whether to add regression line where the slope and
intercept are obtained from \code{\link[mcr:mcreg]{mcr::mcreg()}} function, default is TRUE.}

\item{equal.axis}{(\code{logical})\cr whether to adjust the ranges of x-axis and y-axis
are identical. If \code{equal.axis = TRUE}, x-axis will be equal to y-axis.}

\item{legend.title}{(\code{logical})\cr whether to present the title in the legend.}

\item{legend.digits}{(\code{integer})\cr the number of digits after the decimal point
in the legend.}
}
\value{
A \code{ggplot} based Bland-Altman plot or regression plot that can be
easily customized using additional \code{ggplot} functions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Draw a ggplot-based difference Bland-Altman plot of reference assay vs. test assay
for \code{BAsummary} object, and a regression plot for \code{MCResult}. Also Providing
the necessary and useful option arguments for presentation.
}
\note{
If you'd like to alter any part that this \code{autoplot} function haven't
provided, adding other \code{ggplot} statements are suggested.
}
\examples{
# Specify the type for difference plot
data("platelet")
object <- blandAltman(x = platelet$Comparative, y = platelet$Candidate)
autoplot(object)
autoplot(object, type = "relative")

# Set the addition parameters for `geom_point`
autoplot(object,
  type = "relative",
  jitter = TRUE,
  fill = "lightblue",
  color = "grey",
  size = 2
)

# Set the color and line type for reference and limits of agreement lines
autoplot(object,
  type = "relative",
  ref.line.params = list(col = "red", linetype = "solid"),
  loa.line.params = list(col = "grey", linetype = "solid")
)

# Set label color, size and digits
autoplot(object,
  type = "absolute",
  ref.line.params = list(col = "grey"),
  loa.line.params = list(col = "grey"),
  label.digits = 2,
  label.params = list(col = "grey", size = 3, fontface = "italic")
)

# Add main title, X and Y axis titles, and adjust X ticks.
autoplot(object,
  type = "absolute",
  x.nbreak = 6,
  main.title = "Bland-Altman Plot",
  x.title = "Mean of Test and Reference Methods",
  y.title = "Reference - Test"
)
# Using the default arguments for regression plot
data("platelet")
fit <- mcreg(
  x = platelet$Comparative, y = platelet$Candidate,
  method.reg = "Deming", method.ci = "jackknife"
)
autoplot(fit)

# Only present the regression line and alter the color and shape.
autoplot(fit,
  identity = FALSE,
  reg.params = list(col = "grey", linetype = "dashed"),
  legend.title = FALSE,
  legend.digits = 4
)
}
\seealso{
\code{\link[=h_difference]{h_difference()}} to see the type details.

\code{\link[mcr:mcreg]{mcr::mcreg()}} to see the regression parameters.
}
