% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R
\name{zero_plus}
\alias{zero_plus}
\title{Make all values strictly higher than zero}
\usage{
zero_plus(x, small_pos = 1e-05)
}
\arguments{
\item{x}{A numeric vector.}

\item{small_pos}{A (small) positive number to replace negative values and 0s.}
}
\value{
A copy of \code{x} in which all values equal to or lower than zero are
replaced by \code{small_pos}.
}
\description{
This is an auxiliary function that makes all values in numeric vector x strictly
positive by replacing all values equal to or lower than zero with
the values in \code{small.pos}. \code{small_pos} stands for 'small positive constant'.
}
\examples{
(x <- rnorm(30))
zero_plus(x)
}
