% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnames.R
\name{short_names}
\alias{short_names}
\alias{drop_path}
\alias{drop_extension}
\title{Shorten filenames}
\usage{
drop_path(x, ...)

drop_extension(x, ...)

short_names(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link{fnames}} or a character vector.}

\item{...}{Additional arguments.}
}
\value{
An object of the same class as \code{x}.
}
\description{
Helper functions that make the paths to a file shorter.
}
\section{Functions}{
\itemize{
\item \code{drop_path()}: Extract the base name of a path, removing the paths leading to it.

\item \code{drop_extension()}: Remove extension from a filename.

\item \code{short_names()}: Remove both paths leading to a file and its extension.

}}
\examples{
cwd_fnames <- as_fnames(c("folder/file1.txt", "folder/file2.txt", "folder/file3.txt"))
drop_path(cwd_fnames)
drop_extension(cwd_fnames)
short_names(cwd_fnames) # same as drop_path(drop_extension(cwd_fnames))
}
