% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeight.R
\name{getWeight}
\alias{getWeight}
\title{Get the overall costs/weight of a subgraph given its edgelist.}
\usage{
getWeight(graph, edgelist, obj.types = NULL)
}
\arguments{
\item{graph}{[\code{\link[grapherator]{grapherator}}]\cr
Graph.}

\item{edgelist}{[\code{matrix(2, k)}]
Matrix of edges (each column is one edge).}

\item{obj.types}{[\code{character}]\cr
How to aggregate edge weights?
Possible values are \dQuote{sum} for sum objective and \dQuote{bottleneck}
for bottleneck/min-max objectives.
Default is \dQuote{sum} for each objective.}
}
\value{
[\code{numeric(2)}] Weight vector.
}
\description{
Get the overall costs/weight of a subgraph given its edgelist.
}
\examples{
# generate a random bi-objective graph
g = genRandomMCGP(5)

# generate a random Pruefer code, i.e., a random spanning tree of g
pcode = sample(1:5, 3, replace = TRUE)

getWeight(g, prueferToEdgeList(pcode))
getWeight(g, prueferToEdgeList(pcode), obj.types = "bottleneck")
}
