% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_ml_models.R
\name{run_regression_submodels}
\alias{run_regression_submodels}
\title{Run regression sub-models}
\usage{
run_regression_submodels(
  input_data,
  id_raster,
  covariates,
  cv_settings,
  model_settings,
  family = "binomial",
  clamping = TRUE,
  use_admin_bounds = FALSE,
  admin_bounds = NULL,
  admin_bounds_id = "polygon_id",
  prediction_range = c(-Inf, Inf),
  verbose = TRUE
)
}
\arguments{
\item{input_data}{A data.frame with at least the following columns:
\itemize{
\item 'indicator': number of "hits' per site, e.g. tested positive for malaria
\item 'samplesize': total population sampled at the site
\item 'x': x position, often longitude
\item 'y': y position, often latitude
}}

\item{id_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} with non-NA pixels delineating the extent of the
study area}

\item{covariates}{(list) Named list of all covariate effects included in the model,
typically generated by \code{\link[=load_covariates]{load_covariates()}}.}

\item{cv_settings}{Named list of cross-validation settings, passed to
\link[caret:trainControl]{caret::trainControl}.}

\item{model_settings}{Named list where the name of each header corresponds to a model
run in \link[caret:train]{caret::train}, and the arguments correspond to the model-specific settings
for that model type.}

\item{family}{(\code{character(1)}, default 'binomial') Statistical model family being
evaluated. For Gaussian models, this function trains against the 'mean' field; for
all other families, this function trains against the ratio of
'indicator':'samplesize'.}

\item{clamping}{(\code{logical(1)}, default TRUE) Should the predictions of individual ML
models be limited to the range observed in the data?}

\item{use_admin_bounds}{(\code{logical(1)}, default FALSE) Use one-hot encoding of
administrative boundaries as a candidate feature?}

\item{admin_bounds}{(\link[sf:sf]{sf}, default NULL) Administrative boundaries to use.
Only considered if \code{use_admin_bounds} is TRUE.}

\item{admin_bounds_id}{(\code{character}, default 'polygon_id') Field to use for
administrative boundary one-hot encoding. Only considered if \code{use_admin_bounds} is
TRUE.}

\item{prediction_range}{(\code{numeric(2)}, default c(-Inf, Inf)) Prediction limits for the
outcome range. Used when the predictions are in a limited range, for example, 0 to 1
or -1 to 1.}

\item{verbose}{(\code{logical(1)}, default TRUE) Log progress for ML model fitting?}
}
\value{
List with two items:
\itemize{
\item "models": A list containing summary objects for each regression model
\item "predictions": Model predictions covering the entire id_raster
}
}
\description{
Wrapper to run many regression sub-models using the caret package
}
\concept{model_fit}
