% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced.R
\name{widen_paths}
\alias{widen_paths}
\title{Spread a value within a matrix}
\usage{
widen_paths(m, value = 1, blocked = NULL, square_corners = FALSE)
}
\arguments{
\item{m}{A \code{matrix}.}

\item{value}{The value to be expanded into neighboring cells. For widening
the paths of the maze, this is the value that represents paths.}

\item{blocked}{Values that should be preserved, regardless of whether or not
the expansion would normally encroach on their cells.}

\item{square_corners}{Whether or not to include diagonals in the expansion.
Including diagonals will preserve square corners, whereas excluding them
(default) creates more rounded looking corners.}
}
\value{
A matrix with the same dimensions as the original, in which cells that border a cell of a particular \code{value} have been assigned that \code{value}.
}
\description{
A function to spread a particular value into neighboring cells of a matrix.
When that matrix is a binary representation of a maze, this can be used to
widen the paths of the maze (subsequently narrowing the walls).
}
\details{
The idea of this function is to let the paths of a maze "seep" into
  the walls. For making a maze-within-a-maze, the walls of the big maze are
  generally not as interesting as the paths, which contain smaller paths.
  Hence why we might want to make the paths wider than the walls. Remember
  that this will affect walls from both sides, so it is necessary to expand
  the matrix twice (via \code{\link{expand_matrix}}) before widening the
  paths for the first time.
}
\examples{
m <- matrix(0, nrow = 5, ncol = 5)
m[3,3] <- 1
widen_paths(m)
widen_paths(m, square_corners = TRUE)

m[,2] <- 2
widen_paths(m, blocked = 2)

}
