% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporalDataFunctions.R
\name{overlap}
\alias{overlap}
\title{Pairwise Mating Timing Comparison}
\usage{
overlap(scene, overlapOrTotal = c("overlap", "total"), compareToSelf = FALSE)
}
\arguments{
\item{scene}{a matingScene object}

\item{overlapOrTotal}{whether to calculate the number of days that each
pair was overlapping in mating receptivity or the total number of days
that either individual was receptive}

\item{compareToSelf}{whether or not to include self comparisons in the
return value}
}
\value{
a matrix containing all pairwise comparisons. If compareToSelf
is FALSE then there will be n rows and n-1 columns. \cr
To index result[i,j] where j > i, use \code{result[i,j-1]}, where \code{result}
is the return value of overlap. There is one attribute "idOrder"
which holds the order of the id column in scene at the time of the function call.
This can be useful to find certain elements in the matrix (see examples). \cr
If scene is a multi-year matingScene, then overlap will return a list of matrices
(as described above) where each matrix represents one year.
}
\description{
Get comparisons of mating timing between all pairs
}
\examples{
pop <- simulateScene()
pop <- pop[order(pop$start),]
daysSync <- overlap(pop)
indices <- which(attr(daysSync, "idOrder") \%in\% c(1, 4))
if (indices[1] <= indices[2]) {
  daysSync[indices[1], indices[2]]
} else {
  daysSync[indices[1], indices[2]-1]
}
}
\author{
Danny Hanson
}
