% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pfynwald.R
\docType{data}
\name{Pfynwald}
\alias{Pfynwald}
\title{Scots pine trees in Pfynwald, Switzerland.}
\format{
An object of class ppp, giving Cartesian xy-coordinate of trees in meters, and their height as mark.
}
\source{
\url{https://envidat.ch/#/metadata/pfynwald}
}
\usage{
data(Pfynwald)
}
\description{
Location and height of trees from the Pfynwald project,
 available via an Open Database License (\url{https://opendata.swiss}),
  which originates from a long-term irrigation experiment begun in 2003 within Switzerland's
   Pfyn-Finges national park.
}
\examples{
 library(spatstat.geom)
 data(Pfynwald)
 plot(Pfynwald)
}
\references{
Schaub, M., Haeni, M., Hug, C., Gessler, A., Rigling, A. (2016). Tree measurements 2002-2016 from the long-term irrigation experiment Pfynwald, Switzerland. EnviDat. \url{https://www.doi.org/10.16904/11}.

Moradi, M., & Eckardt, M. (2025). Inhomogeneous mark correlation functions for general marked point processes. arXiv e-prints, arXiv-2505.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
\keyword{datasets}
