% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F18.R
\name{F18}
\alias{F18}
\title{Goldstein-Price Function (F18)}
\usage{
F18(x)
}
\arguments{
\item{x}{Numeric vector of length 2 (2-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function with four local minima and one global minimum.
Fixed dimension of 2.
}
\details{
\strong{Formula:}
\deqn{f(x) = (1 + (x_1 + x_2 + 1)^2(19 - 14x_1 + 3x_1^2 - 14x_2 + 6x_1 x_2 + 3x_2^2))
  \times (30 + (2x_1 - 3x_2)^2(18 - 32x_1 + 12x_1^2 + 48x_2 - 36x_1 x_2 + 27x_2^2))}

\strong{Global minimum:} \eqn{f(0, -1) = 3}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 2
  \item Number of local minima: 4
  \item Default bounds: \eqn{[-2, 2]^2}
}

The Goldstein-Price function has a complex landscape with the global
minimum surrounded by local minima of increasing value.
}
\examples{
F18(c(0, -1))  # Returns 3 (global minimum)
F18(c(0, 0))   # Returns 600

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters.
}
