% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{gph.param}
\alias{gph.param}
\title{Generate GPH using the information on data}
\usage{
gph.param(data, skel, ...)
}
\arguments{
\item{data}{A dataframe}

\item{skel}{An instance of skeleton of GPH.}

\item{...}{Others}
}
\value{
An instance of GPH
}
\description{
Generate GPH randomly and adjust parameters to fit its first moment to
the first moment of data.
}
\examples{
## Create data
wsample <- rweibull(10, shape=2)
(dat <- data.frame.phase.time(x=wsample))

## Generate PH that is fitted to dat
(model <- gph.param(data=dat, skel=ph(5)))

}
