% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{GPHClass}
\alias{GPHClass}
\title{General phase-type distribution}
\description{
General phase-type distribution

General phase-type distribution
}
\details{
A continuous distribution dominated by a continuous-time Markov chain.
A random time is given by an absorbing time.
}
\note{
This function provides the values of p.d.f. for PH distribution with
the uniformization technique.

This function provides the values of c.d.f. for PH distribution with
the uniformization technique.

This function provides the values of complementary c.d.f. for
PH distribution with the uniformization technique.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GPHClass-alpha}{\code{GPHClass$alpha()}}
\item \href{#method-GPHClass-Q}{\code{GPHClass$Q()}}
\item \href{#method-GPHClass-xi}{\code{GPHClass$xi()}}
\item \href{#method-GPHClass-new}{\code{GPHClass$new()}}
\item \href{#method-GPHClass-copy}{\code{GPHClass$copy()}}
\item \href{#method-GPHClass-size}{\code{GPHClass$size()}}
\item \href{#method-GPHClass-df}{\code{GPHClass$df()}}
\item \href{#method-GPHClass-moment}{\code{GPHClass$moment()}}
\item \href{#method-GPHClass-print}{\code{GPHClass$print()}}
\item \href{#method-GPHClass-pdf}{\code{GPHClass$pdf()}}
\item \href{#method-GPHClass-cdf}{\code{GPHClass$cdf()}}
\item \href{#method-GPHClass-ccdf}{\code{GPHClass$ccdf()}}
\item \href{#method-GPHClass-sample}{\code{GPHClass$sample()}}
\item \href{#method-GPHClass-emfit}{\code{GPHClass$emfit()}}
\item \href{#method-GPHClass-init}{\code{GPHClass$init()}}
\item \href{#method-GPHClass-clone}{\code{GPHClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-alpha"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-alpha}{}}}
\subsection{Method \code{alpha()}}{
Get alpha
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$alpha()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of alpha
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-Q"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-Q}{}}}
\subsection{Method \code{Q()}}{
Get Q
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$Q()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A matrix of Q
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-xi"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-xi}{}}}
\subsection{Method \code{xi()}}{
Get xi
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$xi()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of xi
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-new"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-new}{}}}
\subsection{Method \code{new()}}{
Create a GPH
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$new(alpha, Q, xi)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{A vector of initial probability}

\item{\code{Q}}{An infinitesimal generator}

\item{\code{xi}}{An exit rate vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of GPH
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-copy"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-copy}{}}}
\subsection{Method \code{copy()}}{
copy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$copy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-size"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-size}{}}}
\subsection{Method \code{size()}}{
The number of phases
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of phases
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-df"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-df}{}}}
\subsection{Method \code{df()}}{
Degrees of freedom
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$df()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The degrees of freedom
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-moment"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-moment}{}}}
\subsection{Method \code{moment()}}{
Moments of GPH
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$moment(k, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{A value to indicate the degrees of moments. k-th moment}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of moments from 1st to k-th moments
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-print"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-print}{}}}
\subsection{Method \code{print()}}{
Print
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-pdf"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-pdf}{}}}
\subsection{Method \code{pdf()}}{
PDF
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$pdf(x, poisson.eps = 1e-08, ufactor = 1.01, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector of points}

\item{\code{poisson.eps}}{A value of tolerance error for uniformization}

\item{\code{ufactor}}{A value of uniformization factor}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of densities.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-cdf}{}}}
\subsection{Method \code{cdf()}}{
CDF
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$cdf(x, poisson.eps = 1e-08, ufactor = 1.01, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector of points}

\item{\code{poisson.eps}}{A value of tolerance error for uniformization}

\item{\code{ufactor}}{A value of uniformization factor}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of probabilities
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-ccdf"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-ccdf}{}}}
\subsection{Method \code{ccdf()}}{
Complementary CDF
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$ccdf(x, poisson.eps = 1e-08, ufactor = 1.01, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector of points}

\item{\code{poisson.eps}}{A value of tolerance error for uniformization}

\item{\code{ufactor}}{A value of uniformization factor}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of probabilities
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-sample"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-sample}{}}}
\subsection{Method \code{sample()}}{
Make a sample
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$sample(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A sample of GPH
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-emfit"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-emfit}{}}}
\subsection{Method \code{emfit()}}{
Run EM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$emfit(data, options, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A dataframe}

\item{\code{options}}{A list of options}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-init"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-init}{}}}
\subsection{Method \code{init()}}{
Initialize with data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$init(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A dataframe}

\item{\code{...}}{Others}

\item{\code{options}}{A list of options}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPHClass-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GPHClass-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPHClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
