% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-grid-ESDAC.R
\encoding{UTF-8}
\name{esp_get_grid_ESDAC}
\alias{esp_get_grid_ESDAC}
\title{National geographic grids from the European Soil Data Centre (ESDAC)}
\source{
\href{https://esdac.jrc.ec.europa.eu/content/european-reference-grids}{EEA reference grid}.
}
\usage{
esp_get_grid_ESDAC(
  resolution = c(10, 1),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{numeric. Resolution of the grid in kms Can be \code{1} or \code{10}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} \code{POLYGON}.
}
\description{
Loads a \code{\link[sf:sf]{sf}} \code{POLYGON} with the geographic grids of Spain as
provided by the European Soil Data Centre (ESDAC).
}
\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\dontrun{
grid <- esp_get_grid_ESDAC()
esp <- esp_get_spain(moveCAN = FALSE)

library(ggplot2)

ggplot(grid) +
  geom_sf() +
  geom_sf(data = esp, color = "grey50", fill = NA) +
  theme_light() +
  labs(title = "ESDAC Grid for Spain")
}
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Panagos P., Van Liedekerke M., Jones A., Montanarella L., "European Soil
Data Centre: Response to European policy support and public data
requirements"; (2012) \emph{Land Use Policy}, 29 (2), pp. 329-338.
\doi{10.1016/j.landusepol.2011.07.003}
\item European Soil Data Centre (ESDAC), esdac.jrc.ec.europa.eu, European
Commission, Joint Research Centre.
}
}
\seealso{
Other geographical grids:
\code{\link{esp_get_grid_BDN}()},
\code{\link{esp_get_grid_MTN}()}
}
\concept{grids}
