% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-cache.R
\name{esp_clear_cache}
\alias{esp_clear_cache}
\title{Clear your \CRANpkg{mapSpain} cache dir}
\usage{
esp_clear_cache(config = FALSE, cached_data = TRUE, verbose = FALSE)
}
\arguments{
\item{config}{logical. If \code{TRUE}, deletes the configuration folder of
\CRANpkg{mapSpain}.}

\item{cached_data}{logical. If \code{TRUE}, deletes your \code{cache_dir} and all
its contents.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
Invisible. This function is called for its side effects.
}
\description{
\strong{Use this function with caution.} It clears your cached data and
configuration, specifically:
\itemize{
\item Deletes the \CRANpkg{mapSpain} configuration directory
(\code{tools::R_user_dir("mapSpain", "config")}).
\item Deletes the \code{cache_dir} directory and its contents.
\item Clears the value stored in \code{Sys.getenv("MAPSPAIN_CACHE_DIR")}.
}
}
\details{
This is an aggressive function intended to reset your installation as if you
had never installed or used \CRANpkg{mapSpain}.
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
my_cache <- esp_detect_cache_dir()

# Set an example cache
ex <- file.path(tempdir(), "example", "cache")
esp_set_cache_dir(ex, verbose = FALSE)

# Restore initial cache
esp_clear_cache(verbose = TRUE)

esp_set_cache_dir(my_cache)
identical(my_cache, esp_detect_cache_dir())
}
}
\seealso{
\code{\link[tools:userdir]{tools::R_user_dir()}}

Other cache utilities: 
\code{\link{esp_set_cache_dir}()}
}
\concept{cache utilities}
