% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symtable.R
\name{symtable}
\alias{symtable}
\title{Examine the Macro Symbol Table}
\usage{
symtable()
}
\value{
An object of class "symtable".  The object contains a list of macro symbols
and their values.  It also contains a list of macro functions, their parameters,
and the associated code.
}
\description{
The \code{symtable} function extracts the contents of the macro symbol table
and macro function list.  The symbol table information is returned as an object.
The object can be printed or navigated programatically.
}
\examples{
library(macro)

# Get path to demo macro program
src <- system.file("extdata/Demo4.R", package = "macro")

# Display source code
# - This is the macro input code
cd <- readLines(src)
cat(paste(cd, "\n"))
# #\% Create some macro variables
# #\%let x <- 1
# #\%let y <- 2
# #\%let z <- &x + &y
#
# #\% Create a macro function
# #\%macro test(vl = Hello!)
# print("&vl")
# #\%mend

# Execute source code
msource(src, echo = FALSE)

# Examine symbol table
res <- symtable()

# View results
print(res)
# # Macro Symbol Table: 3 macro variables
#   Name Value
# 1   &x     1
# 2   &y     2
# 3   &z 1 + 2
# # Macro Function List: 1 macro functions
#   Name Parameter Default
# 1 test        vl  Hello!

# View results structure
print(res, verbose = TRUE)
# $variables
# $variables$`&x`
# [1] "1"
#
# $variables$`&y`
# [1] "2"
#
# $variables$`&z`
# [1] "1 + 2"
#
#
# $functions
# $functions$test
# $functions$test$parameters
# $functions$test$parameters$vl
# [1] "Hello!"
#
#
# $functions$test$code
# [1] "print(\"&vl\")"
# attr(,"start")
# [1] 8
# attr(,"end")
# [1] 8

}
\seealso{
\code{\link[=msource]{msource()}}

Other symtable: 
\code{\link{print.symtable}()},
\code{\link{symclear}()},
\code{\link{symget}()},
\code{\link{symput}()}
}
\concept{symtable}
