% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\title{Calculate Cognitive Test Scores}
\usage{
score(data)
}
\arguments{
\item{data}{A dataframe containing the cognitive test data, including columns for word recall,
serial subtraction, and backwards counting tasks.}
}
\value{
A dataframe with the following computed scores:
\itemize{
\item \code{Total_I}: Total score for immediate word recall.
\item \code{Total_D}: Total score for delayed word recall.
\item \code{Total_Sub}: Total score for serial subtraction.
\item \code{Total_Count}: Total score for backwards counting.
}
}
\description{
This function calculates various cognitive test scores from a dataset, including word recall,
serial subtraction, and backwards counting. It computes total scores for immediate and delayed word recall,
scores for serial subtraction tasks, and a total score for backwards counting.
}
\details{
The function applies scoring functions to the cognitive test data:
\itemize{
\item Word recall: Scores immediate and delayed recall using the \code{score_recall} function, and computes total scores.
\item Serial subtraction: Applies the \code{score_subtraction} function to calculate scores for each subtraction step, and computes the total score.
\item Backwards counting: Assigns 2 points for correct counting on the first try, 1 point for correct counting on the second try, and 0 for incorrect counting.
}
}
\examples{
# Assuming `cog_data` is a dataframe with the relevant columns
scored_data <- score(cog_data)

}
