% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.AgreementBudget.R
\docType{methods}
\name{plot.AgreementBudget}
\alias{plot.AgreementBudget}
\alias{plot,AgreementBudget,ANY-method}
\title{Plot method for AgreementBudget objects}
\usage{
\method{plot}{AgreementBudget}(x, y, from, to,
  col = RColorBrewer::brewer.pal(5, "Set2"), key, scales, xlab, ylab, ...)

\S4method{plot}{AgreementBudget,ANY}(x, y, from, to,
  col = RColorBrewer::brewer.pal(5, "Set2"), key, scales, xlab, ylab, ...)
}
\arguments{
\item{x}{an AgreementBudget object}

\item{y}{not used}

\item{from}{optional numeric value representing a land use category. If 
provided without \code{to} the figure of merit for all transitions from this
category will be plotted}

\item{to}{similar to \code{from}. If provided with a valid \code{from}
argument the transition defined by these two arguments (i.e. \code{from} ->
\code{to}) will be plotted}

\item{col}{character specifying the plotting colour. Default is to use the
'Set2' palette from \code{RColorBrewer}}

\item{key}{list. See \code{lattice::\link[lattice]{xyplot}}}

\item{scales}{list. See \code{lattice::\link[lattice]{xyplot}}}

\item{xlab}{character or expression. See \code{lattice::\link[lattice]{xyplot}}}

\item{ylab}{character or expression. See \code{lattice::\link[lattice]{xyplot}}}

\item{\dots}{additional arguments to \code{lattice::\link[lattice]{xyplot}}}
}
\value{
A trellis object.
}
\description{
Plot an \code{\link{AgreementBudget}} object.
}
\details{
The plot layout is based on work presented in Pontius et al. (2011)
}
\examples{

## see lulcc-package examples
}
\references{
Pontius Jr, R.G., Peethambaram, S., Castella, J.C. (2011).
Comparison of three maps at multiple resolutions: a case study of land change
simulation in Cho Don District, Vietnam. Annals of the Association of American
Geographers 101(1): 45-62.
}
\seealso{
\code{\link{AgreementBudget}}, \code{lattice::\link[lattice]{xyplot}}
}
