% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{hazard_sub}
\alias{hazard_sub}
\title{Hazard Function for Sub Population}
\usage{
hazard_sub(
  piecewiseSurvivalTime = 0,
  hazard_itt = 0.0578,
  hazard_pos = 0.02,
  p_pos = 0.5
)
}
\arguments{
\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{hazard_itt}{A scalar or numeric vector specifying the
hazard(s) for the ITT population based on a pwexp distribution.}

\item{hazard_pos}{A scalar or numeric vector specifying the
hazard(s) for the biomarker positive sub population
based on a pwexp distribution.}

\item{p_pos}{A numeric value specifying the prevalence of the
biomarker positive sub population.}
}
\value{
A numeric vector representing the estimated hazard rates
for the pwexp distribution of the biomarker negative sub population.
}
\description{
Computes the hazard function of a piecewise exponential (pwexp)
distribution for the biomarker negative sub population, such that the
resulting survival function for the ITT population
closely matches a given pwexp survival function.
}
\details{
This function determines the hazard vector \eqn{\lambda_{\text{neg}}}
for the pwexp distribution of the biomarker negative sub population,
so that the implied survival function for the ITT population closely
matches the specified pwexp distribution with hazard vector
\eqn{\lambda_{\text{itt}}}.

Let \eqn{p_{\text{pos}}} be the
prevalence of the biomarker positive sub population,
then the survival function for the ITT population is given by
\deqn{S_{\text{itt}}(t) = p_{\text{pos}} S_{\text{pos}}(t) +
(1 - p_{\text{pos}}) S_{\text{neg}}(t)}
where \eqn{S_{\text{pos}}(t)} and \eqn{S_{\text{neg}}(t)} are
the survival functions for the biomarker positive and
biomarker negative sub populations, respectively.

Matching is performed sequentially at the internal cutpoints
\eqn{u_2, ..., u_J} and at the point
\eqn{u_J + \log(2)/\lambda_{\text{itt},J}} for the final interval
to solve for \eqn{\lambda_{\text{neg},1}, \ldots,
\lambda_{\text{neg},J-1}} and \eqn{\lambda_{\text{neg},J}}, respectively.
}
\examples{
u <- c(0, 1, 3, 4)
lambda_itt <- c(0.0151, 0.0403, 0.0501, 0.0558)
lambda_pos <- c(0.0115, 0.0302, 0.0351, 0.0404)
p_pos <- 0.3
hazard_sub(u, lambda_itt, lambda_pos, p_pos)

}
\author{
Kaifeng Lu (\email{kaifenglu@gmail.com})
}
