% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorad-transform.R
\name{lorad_transform}
\alias{lorad_transform}
\title{Log (or log-ratio) transform parameters having constrained support}
\usage{
lorad_transform(params, colspec)
}
\arguments{
\item{params}{Data frame containing a column for each model parameter
sampled as well as one or more columns that, when summed, constitute
the log joint posterior kernel}

\item{colspec}{Named character vector matching each column name in
params with a column specification}
}
\value{
A new data frame comprising transformed parameter values
with a final column holding the log joint posterior kernel
}
\description{
Log-transforms parameters with support (0,infinity), log-ratio transforms
K-dimensional parameters with support a (K-1)-simplex, logit transforms
parameters with support [0,1], and leaves unchanged parameters with
unconstrained support (-infinity, infinity).
}
