% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\docType{package}
\name{logr}
\alias{logr}
\alias{logr-package}
\title{Creates log files}
\description{
The \strong{logr} package contains functions to
easily create log files.
}
\details{
The \strong{logr} package helps create log files for R scripts.  The package
provides easy logging, without the complexity of other logging systems.
It is
designed for analysts who simply want a written log of the their program
execution.  The package is designed as a wrapper to
the base R \code{sink()} function.
}
\section{How to use}{

There are three main \strong{logr} functions:
\itemize{
\item \code{\link{log_open}}
\item \code{\link{log_print}}
\item \code{\link{log_close}}
}
The \code{log_open()} function initiates the log.  The
\code{log_print()} function prints an object to the log.  The
\code{log_close()} function closes the log.  In normal situations,
a user would place the call to
\code{log_open} at the top of the program, call \code{log_print()}
as needed in the
program body, and call \code{log_close()} once at the end of the program.

Logging may be controlled globally using the options "logr.on" and
"logr.notes".  Both options accept TRUE or FALSE values, and control
log printing or log notes, respectively.

See function documentation for additional details.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://logr.r-sassy.org}
  \item \url{https://github.com/dbosak01/logr}
  \item Report bugs at \url{https://github.com/dbosak01/logr/issues}
}

}
\author{
\strong{Maintainer}: David Bosak \email{dbosak01@gmail.com}

Other contributors:
\itemize{
  \item Rikard Isaksson [contributor]
}

}
\keyword{internal}
