#' Test the computer player performance
#'
#' Assesses (by simulation) the performance of an algorithm for detecting non linearity/heteroscedasticity/non normality (\code{\link{ComputerDecision.default}}) on data generated by the function \code{Simulation} (\code{\link{Simulation.default}}).
#'
#' @author Francesco Pauli, \email{francesco.pauli@@deams.units.it}
#' @seealso \code{\link{ComputerDecision.default}},\code{\link{Simulation.default}}
#' @keywords -
#'
#' @param m number of simulations
#' @param ComputerDecision function which returns a computer guess on the violation of assumption (see \code{\link{ComputerDecision.default}})
#' @param Simulation function which return a sample generated according to different assumptions (see \code{\link{Simulation.default}})
#'
#' @return
#' \item{table}{a 4x4 matrix, this is the frequency of the true data generating mechanism (rows) and the computer guess (column)}
#'
#' @examples
#' checksim(10)
#'
#' @export

checksim=function(m,ComputerDecision=ComputerDecision.default,Simulation=Simulation.default){
  vero=rep(NA,m)
  comp=rep(NA,m)
  for (i in 1:m){
    print(i)
    vero[i]=sample(1:4,1)
    c=Simulation(vero[i])
    fit=lm(c$y~c$x)
    comp[i]=ComputerDecision(fit)$nonrvcomputer
  }
  return(table=table(vero,comp))
}
